package com.yidianling.im.ui.view;

import android.content.Context;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.yidianling.im.R;
import com.yidianling.im.bean.MsgData;

/**
 * 系统消息列表item
 * Created by softrice on 15/12/10.
 */
public class MsgListItemView extends LinearLayout {

    TextView tv_content;
    TextView tv_time;
    TextView title;

    private int type = 0;

    public MsgListItemView(Context context, int type) {
        super(context);
        this.type = type;
        inflate(context, R.layout.im_ui_msg_list_item, this);
        tv_content = findViewById(R.id.tv_content);
        tv_time = findViewById(R.id.tv_time);
        title = findViewById(R.id.title);
    }

    public void setData(MsgData msgData) {
        if (msgData.is_read == 2) {//已读
            title.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
            title.setTextColor(getResources().getColor(R.color.platform_color_878787));
            tv_content.setTextColor(getResources().getColor(R.color.platform_color_999999));
        } else {//未读
            title.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.im_red_dot, 0);
            title.setTextColor(getResources().getColor(R.color.platform_color_242424));
            tv_content.setTextColor(getResources().getColor(R.color.platform_color_666666));
        }
        tv_content.setText(msgData.content);
        tv_time.setText(msgData.create_time);
        title.setText(msgData.type_title);
    }
}
