package com.yidianling.im.ui.widget;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import android.view.Gravity;
import android.view.Window;
import android.widget.ImageView;

import com.yidianling.im.R;
import com.yidianling.im.router.ImIn;


/**
 * 群聊历史记录弹窗提示
 * Created by hgw on 2017/4/27.
 */

public class ChatTeamHisDialog extends Dialog{

    private Context context;

    private ImageView img;

    public ChatTeamHisDialog(@NonNull Context context) {
        super(context);
        this.context = context;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        setContentView(R.layout.im_dialog_chatteam_his);
        img = (ImageView) findViewById(R.id.img_tip);
        img.setOnClickListener(view -> {
            ImIn.INSTANCE.setChatTeamHisShowed();

            dismiss();
        });
        setCancelable(false);
        setCanceledOnTouchOutside(false);
        getWindow().setGravity(Gravity.RIGHT|Gravity.TOP);
        getWindow().setBackgroundDrawableResource(R.color.im_transparent);
    }

    @Override
    public void show() {
        if (null == context){
            return;
        }
        if (context instanceof Activity){
            if (((Activity)context).isFinishing()){
                return;
            }
        }
        super.show();
    }
}
