package com.yidianling.uikit.api;

import android.content.Context;

import com.netease.nimlib.sdk.msg.attachment.MsgAttachment;
import com.netease.nimlib.sdk.msg.constant.SessionTypeEnum;
import com.netease.nimlib.sdk.msg.model.IMMessage;
import com.netease.nimlib.sdk.team.constant.TeamTypeEnum;
import com.netease.nimlib.sdk.team.model.Team;
import com.yidianling.nimbase.api.BaseNimUIKitImpl;
import com.yidianling.nimbase.api.model.session.SessionCustomization;
import com.yidianling.uikit.business.contact.selector.activity.ContactSelectActivity;
import com.yidianling.uikit.business.session.activity.YDLP2PMessageActivity;
import com.yidianling.uikit.business.session.activity.YDLTeamMessageActivity;
import com.yidianling.uikit.business.session.viewholder.MsgViewHolderBase;
import com.yidianling.uikit.business.session.viewholder.MsgViewHolderFactory;
import com.yidianling.uikit.business.team.activity.AdvancedTeamInfoActivity;
import com.yidianling.uikit.business.team.activity.NormalTeamInfoActivity;
import com.yidianling.uikit.custom.bridge.IP2PCustomActionHandler;

/**
 * UIKit能力实现类。
 */
public final class NimUIKitImpl extends BaseNimUIKitImpl {


    public static void registerMsgItemViewHolder(Class<? extends MsgAttachment> attach, Class<? extends MsgViewHolderBase> viewHolder) {
        MsgViewHolderFactory.register(attach, viewHolder);
    }

    public static void registerTipMsgViewHolder(Class<? extends MsgViewHolderBase> viewHolder) {
        MsgViewHolderFactory.registerTipMsgViewHolder(viewHolder);
    }

    public static void startChatting(Context context, String id, SessionTypeEnum sessionType, SessionCustomization
            customization, IMMessage anchor,IP2PCustomActionHandler l) {
        if (sessionType == SessionTypeEnum.P2P) {
            YDLP2PMessageActivity.start(context, id, customization, anchor,l);
        } else if (sessionType == SessionTypeEnum.Team) {
            YDLTeamMessageActivity.start(context, id, customization, null, anchor,l);
        }
    }

    public static void startContactSelector(Context context, ContactSelectActivity.Option option, int requestCode) {
        ContactSelectActivity.startActivityForResult(context, option, requestCode);
    }

    public static void startTeamInfo(Context context, String teamId) {
        Team team = NimUIKit.getTeamProvider().getTeamById(teamId);
        if (team == null) {
            return;
        }
        if (team.getType() == TeamTypeEnum.Advanced) {
            AdvancedTeamInfoActivity.start(context, teamId); // 启动固定群资料页
        } else if (team.getType() == TeamTypeEnum.Normal) {
            NormalTeamInfoActivity.start(context, teamId); // 启动讨论组资料页
        }
    }


}
