package com.yidianling.uikit.business.session.actions;

import android.Manifest;
import androidx.appcompat.app.AppCompatActivity;
import android.util.Log;

import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.listener.OnResultCallbackListener;
import com.miracle.view.imageeditor.utils.FileUtils;
import com.tbruyelle.rxpermissions2.RxPermissions;
import com.ydl.ydlcommon.actions.imagepicker.YDLImagePicker;
import com.yidianling.common.tools.ToastUtil;
import com.yidianling.nimbase.business.session.actions.BaseAction;

import java.io.File;
import java.util.List;

/**
 * Created by zhoujianghua on 2015/7/31.
 */
public abstract class PickImageAction extends BaseAction {

    private static final int PICK_IMAGE_COUNT = 9;
    private static final int PORTRAIT_IMAGE_WIDTH = 720;

    public static final String MIME_JPEG = "image/jpeg";
    public static final String JPG = ".jpg";

    private boolean multiSelect;
    private boolean crop = false;

    protected abstract void onPicked(File file);

    protected PickImageAction(int iconResId, int titleId, boolean multiSelect) {
        super(iconResId, titleId);
        this.multiSelect = multiSelect;

    }

    @Override
    public void onClick() {
        new RxPermissions(getActivity()).requestEach(Manifest.permission.CAMERA)
                .subscribe(permission -> {
                    if (permission.granted) {
                        selectImage();
                    } else if (permission.shouldShowRequestPermissionRationale) {
                        ToastUtil.toastShort("权限被拒绝，无法选择图片");
                    } else {
                        ToastUtil.toastShort("请到应用设置中开启相机权限");
                    }
                }, throwable -> {
                    Log.i("PickImageAction",throwable.getMessage());
                });
    }

    private void selectImage(){
        YDLImagePicker.INSTANCE.startPicker((AppCompatActivity) getActivity(),9, new OnResultCallbackListener() {
            @Override
            public void onResult(List<LocalMedia> list) {
                if (list.isEmpty()) {
                    return;
                }
                for (int i = 0; i < list.size(); i++) {
                    onPicked(FileUtils.INSTANCE.getFileByUri(getActivity(),list.get(i).getPath()));
                }
            }

            @Override
            public void onCancel() {

            }
        });

    }

}
