package com.yidianling.uikit.business.session.activity;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;

import com.yidianling.im.R;
import com.yidianling.nimbase.api.model.session.SessionCustomization;
import com.yidianling.nimbase.business.preference.UserPreferences;
import com.yidianling.nimbase.business.session.constant.Extras;
import com.yidianling.nimbase.common.activity.UI;
import com.yidianling.nimbase.common.util.sys.ScreenUtil;
import com.yidianling.uikit.business.session.fragment.YDLMessageFragment;
import com.yidianling.uikit.custom.bridge.ActionHandlerStorage;
import com.yidianling.uikit.custom.bridge.IP2PCustomActionHandler;
import com.yidianling.uikit.custom.widget.TitleBarBottom;

import java.util.List;


/**
 * Created by zhoujianghua on 2015/9/10.
 */
public abstract class YDLBaseMessageActivity extends UI {

    protected String sessionId;

    private SessionCustomization customization;

    public YDLMessageFragment messageFragment;

    public YDLMessageFragment getYDLMessageFragment() {
        return messageFragment;
    }

    protected abstract YDLMessageFragment fragment();

    protected abstract int getContentViewId();

    protected abstract void initToolBar();

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(getContentViewId());
        parseIntent();
        initToolBar();

        if (ActionHandlerStorage.getL(sessionId) != null) {
            ActionHandlerStorage.getL(sessionId).put(this);
        }

        messageFragment = (YDLMessageFragment) switchContent(fragment());
    }

    @Override
    public void onBackPressed() {
        if (messageFragment == null || !messageFragment.onBackPressed()) {
            super.onBackPressed();
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);

        if (messageFragment != null) {
            messageFragment.onActivityResult(requestCode, resultCode, data);
        }

        if (customization != null) {
            customization.onActivityResult(this, requestCode, resultCode, data);
        }
    }

    private void parseIntent() {
        sessionId = getIntent().getStringExtra(Extras.EXTRA_ACCOUNT);
        customization = (SessionCustomization) getIntent().getSerializableExtra(Extras.EXTRA_CUSTOMIZATION);
    }

    @Override
    protected void onResume() {
        super.onResume();
        if (null == ActionHandlerStorage.getL(sessionId)) {
            return;
        }
        ActionHandlerStorage.getL(sessionId).resumeUm(this);
    }

    @Override
    protected void onPause() {
        super.onPause();
        if (null == ActionHandlerStorage.getL(sessionId)) {
            return;
        }
        ActionHandlerStorage.getL(sessionId).pauseUm(this);
    }


    protected TitleBarBottom tb;

    //==================== ChatUI Override ====================

    @Override
    @SuppressLint("CheckResult")
    public void setToolBar(int toolBarId) {
        tb = findViewById(toolBarId);
        if (ActionHandlerStorage.getL(sessionId) != null && ActionHandlerStorage.getL(sessionId).getInfo() != null) {
            tb.setTitle(ActionHandlerStorage.getL(sessionId).getInfo().name);
        }
        if (ActionHandlerStorage.getL(sessionId) != null) {
            ActionHandlerStorage.getL(sessionId).setmActivity(this);
        }
        if (!UserPreferences.isEarPhoneModeEnable()) {
            tb.setTitleRightDraw(null);
        } else {
            tb.setTitleRightDraw(getResources().getDrawable(R.drawable.im_erduoxiaolv));
        }
        if (customization != null) {
            addRightCustomViewOnActionBar(this, customization.buttons);
        }
    }
    // 添加action bar的右侧按钮及响应事件
    private void addRightCustomViewOnActionBar(Activity activity, List<SessionCustomization.OptionsButton> buttons) {
        if (buttons == null || buttons.size() == 0) {
            return;
        }
        TitleBarBottom tb = getTitleBarBottom();
        if (tb == null) {
            return;
        }

        LinearLayout view = (LinearLayout) LayoutInflater.from(activity).inflate(R.layout.im_nim_action_bar_custom_view, null);


        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.MATCH_PARENT);
        for (final SessionCustomization.OptionsButton button : buttons) {
            ImageView imageView = new ImageView(activity);
            imageView.setImageResource(button.iconId);
            imageView.setPadding(ScreenUtil.dip2px(10), 0, ScreenUtil.dip2px(20), 0);
            imageView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    button.onClick(YDLBaseMessageActivity.this, v, sessionId);
                }
            });
            view.addView(imageView, params);
        }

        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.MATCH_PARENT);
        layoutParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
        tb.addView(view, layoutParams);
    }

    public TitleBarBottom getTitleBarBottom() {
        return tb;
    }

    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        IP2PCustomActionHandler actionHandler = ActionHandlerStorage.getL(sessionId);
        if (null == actionHandler) {
            return;
        }
        if (null == actionHandler.getmActivity()) {
            actionHandler.setmActivity(this);
        }
    }

    @Override
    public void setTitle(CharSequence title) {
        super.setTitle(title);
        if (null == tb) {
            return;
        }
        tb.setTitle(title.toString());
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }
}
