package com.yidianling.uikit.business.session.view

import android.content.Context
import android.text.Spannable
import android.text.SpannableString
import android.text.TextUtils
import android.text.style.ForegroundColorSpan
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import com.yidianling.im.R
import kotlinx.android.synthetic.main.im_item_view_common_question.view.*

/**
 * @author jiucheng
 * @描述:
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2019/12/9
 */
class CommonQuestionItemView(var mContext: Context) : LinearLayout(mContext) {


    init {
        var parmas = LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT,ViewGroup.LayoutParams.WRAP_CONTENT)
        layoutParams = parmas
        View.inflate(mContext, R.layout.im_item_view_common_question, this)
        orientation = VERTICAL
    }

    fun setData(title: String, keyWords: String?, isLast: Boolean) {
        if (TextUtils.isEmpty(keyWords)) {
            tv_title.text = title
        } else {
            if (title.contains(keyWords!!)) {
                val temp = title.split(keyWords)
                val spanString = SpannableString(temp[0] + keyWords + temp[1])
                spanString.setSpan(ForegroundColorSpan(resources.getColor(R.color.platform_main_theme)), temp[0].length, (temp[0] + keyWords).length, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE)
                tv_title.text = spanString
            } else {
                tv_title.text = title
            }
        }
        if (isLast) {
            view_line.visibility = View.GONE
        } else {
            view_line.visibility = View.VISIBLE
        }
    }
}
