package com.yidianling.uikit.business.session.view

import android.content.Context
import androidx.recyclerview.widget.RecyclerView
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import com.ydl.ydlcommon.view.WrapContentLinearLayoutManager
import com.yidianling.common.tools.RxImageTool
import com.yidianling.im.R
import com.yidianling.uikit.custom.http.response.CommonQuestionBean
import kotlinx.android.synthetic.main.im_view_common_question.view.*

/**
 * @author jiucheng
 * @描述:私聊常见问题view
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2019/12/9
 */
class CommonQuestionView(var mContext: Context) : LinearLayout(mContext) {
    var listener: OnSelectItemListener? = null

    init {
        var parmas = LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT)
        layoutParams = parmas
        View.inflate(mContext, R.layout.im_view_common_question, this)
        orientation = VERTICAL
    }

    fun setData(list: List<CommonQuestionBean>) {
        if (list.isEmpty()) {
            visibility = View.GONE
            return
        }
        if (list.size > 4) {
            var parmas = LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, RxImageTool.dp2px(214f))
            content_view.layoutParams = parmas
        }

        val adapter = CommonQuestionAdapter(mContext, list) { title, id ->
            listener!!.onSelect(title, id)
            listener!!.close()
        }
        var layoutManager = WrapContentLinearLayoutManager(mContext)
        content_view.layoutManager = layoutManager as RecyclerView.LayoutManager?
        content_view.adapter = adapter

        rl_close.setOnClickListener {
            listener!!.close()
        }
    }

    fun show() {
        visibility = View.VISIBLE
    }

    fun hide() {
        visibility = View.GONE
    }

    interface OnSelectItemListener {
        fun onSelect(title: String, id: String)

        fun close()
    }
}