package com.yidianling.uikit.business.session.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;

import androidx.viewpager.widget.ViewPager;

/**
 * Created by haorui on 2019-12-27.
 * Des:修复Android 系统级别bug
 *
 *     Android 处理图片放大缩小时报错java.lang.IllegalArgumentException: pointerIndex out of range pointerIndex=-1
 *     https://github.com/chrisbanes/PhotoView/issues/31
 */
public class ImageOriginPager extends ViewPager {

    public ImageOriginPager(Context context) {
        super(context);
    }

    public ImageOriginPager(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public boolean onTouchEvent(MotionEvent ev) {
        try {
            return super.onTouchEvent(ev);
        } catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent ev) {
        try {
            return super.onInterceptTouchEvent(ev);
        } catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        return false;
    }
}
