package com.yidianling.uikit.custom.widget.expertConsultService.view

import android.content.Context
import android.view.View
import android.widget.RelativeLayout
import com.ydl.webview.H5Params
import com.ydl.webview.NewH5Activity
import com.ydl.ydlcommon.base.config.HttpConfig
import com.ydl.ydlcommon.utils.actionutil.ActionCountUtils
import com.yidianling.common.tools.RxDeviceTool
import com.yidianling.im.R
import com.yidianling.uikit.custom.bridge.ActionHandlerStorage
import com.yidianling.uikit.custom.http.response.ServiceItemBean
import com.yidianling.uikit.custom.widget.expertConsultService.callback.ConsultServiceViewCallback
import kotlinx.android.synthetic.main.im_expert_consult_service_detail_view.view.*

class ExpertConsultServiceDetailView : RelativeLayout {


    constructor(context: Context, listener: ConsultServiceViewCallback,isBusy:Boolean,toUid:String) : super(context) {
        mListener = listener
        mContext = context
        mIsBusy = isBusy
        mToUid = toUid
        initView()
    }

    private var mListener: ConsultServiceViewCallback? = null
    private var mContext: Context? = null
    private var mIsBusy:Boolean = false
    private var mToUid:String = ""


    private fun initView() {

        val mWidth: Int = RxDeviceTool.getScreenWidth(mContext)
        val mHeight: Int = LayoutParams.MATCH_PARENT

        val params = LayoutParams(
            mWidth,
            mHeight
        )
        params.height = mHeight
        layoutParams = params

        View.inflate(mContext, R.layout.im_expert_consult_service_detail_view, this)

        im_expert_service_list_left_back_btn.setOnClickListener {
            mListener?.onBackClick()
        }
    }

    /**
     * 设置数据
     */
    fun updateData(bean: ServiceItemBean.ProductsBean) {
        val mCompare: Comparator<ServiceItemBean.ProductsBean.ProductSpecDtosBean> = Comparator { o1, o2 ->
            val res = o1.price.compareTo(o2.price)
            when {
                res == 0 -> 0
                res > 0 -> -1
                else -> 1
            }
        }
        if (bean.productSpecDtos != null && bean.productSpecDtos.size > 0) {
            val mBean: ServiceItemBean.ProductsBean.ProductSpecDtosBean = bean.productSpecDtos.sortedWith(mCompare).last()
            //价格，取productSpecDtos数组最后一个价格，不保留小数
            consult_service_service_price.text = String.format(
                "%.0f",
                mBean.price
            )

            if (bean.productDto.isPackage == 2) {
                consult_service_price_right.text = "/${mBean.spec2}分钟" //例： 套餐展示"/60分钟"
            }else {
                consult_service_price_right.text = "/次"//例： 不是套餐展示"/次"
            }
        }

        consult_service_title.text = bean.productDto.name ?: ""
        consult_service_desc.text = bean.productDto.description ?: ""

        //是否是套餐
        if (bean.productDto.isPackage == 2) {
            consult_service_is_package.text = "套餐"
            consult_service_times.text = "${bean.productDto.packageNum}次"

            //起售次数展示
            consult_service_low_buy_time.visibility = View.VISIBLE
            consult_service_low_buy_time.text = "(${bean.productDto.packageNum}次起售)"
        } else {
            consult_service_is_package.text = "单次"
            consult_service_times.text = "1次"
            consult_service_low_buy_time.visibility = View.GONE
        }

        consult_service_once_time_type.text = "${bean.productDto.minOrderTime}分钟"

        consult_service_service_type.text = bean.productDto.consultWays

        if (mIsBusy){
            consult_service_btn.background.alpha = 100
        }
        consult_service_btn.setOnClickListener {
            if (mIsBusy){
                // 埋点
                ActionCountUtils.baiDuCountSign3("ydl_user_product_page","reserve_now_click",mToUid, ActionHandlerStorage.getL(mToUid).info.name,"1")
            }else{
                // 埋点
                ActionCountUtils.baiDuCountSign3("ydl_user_product_page","reserve_now_click",mToUid, ActionHandlerStorage.getL(mToUid).info.name,"0")
                NewH5Activity.start(mContext, H5Params(HttpConfig.MH5_URL + "consult/#/pages/DownOrder/DownOrder?product_id=" + bean.productDto.id, null))
            }
        }
    }
}