package com.yidianling.uikit.custom.widget.expertConsultService.view

import android.content.Context
import android.graphics.Color
import android.graphics.Typeface
import android.util.AttributeSet
import android.view.View
import android.widget.LinearLayout
import com.yidianling.im.R
import kotlinx.android.synthetic.main.im_expert_consult_service_type_item_view.view.*

class ExpertConsultServiceTypeItemView : LinearLayout {


    constructor(context: Context) : super(context) {
        mContext = context
        initView()
    }

    constructor(context: Context, attrs: AttributeSet) : super(context, attrs) {
        mContext = context
        initView()
    }

    constructor(context: Context, attrs: AttributeSet, defStyle: Int) : super(
        context,
        attrs,
        defStyle
    ) {
        mContext = context
        initView()
    }

    private var mContext: Context? = null


    private fun initView() {

        val mWidth: Int = LayoutParams.WRAP_CONTENT
        val mHeight: Int = LayoutParams.WRAP_CONTENT

        val params = LayoutParams(
            mWidth,
            mHeight
        )
        params.height = mHeight
        layoutParams = params

        View.inflate(mContext, R.layout.im_expert_consult_service_type_item_view, this)
    }

    /**
     * 设置数据
     */
    fun setData(typeString: String, isSelected: Boolean) {
        im_expert_info_dialog_type_item_text.text = typeString

        if (isSelected) {
            im_expert_info_dialog_type_item_text.setTextColor((Color.parseColor("#1DA1F2")))
            im_expert_info_dialog_type_item_text.typeface = Typeface.defaultFromStyle(Typeface.BOLD)
            im_expert_info_dialog_type_item_text.setBackgroundResource(R.drawable.im_expert_info_dialog_type_item_selected_bg)
        } else {
            im_expert_info_dialog_type_item_text.setTextColor((Color.parseColor("#999999")))
            im_expert_info_dialog_type_item_text.typeface = Typeface.defaultFromStyle(Typeface.NORMAL)
            im_expert_info_dialog_type_item_text.setBackgroundResource(R.drawable.im_expert_info_dialog_type_item_unselected_bg)
        }
    }

    /**
     * 更新状态
     */
    fun updateStatus(isSelected: Boolean) {
        if (isSelected) {
            im_expert_info_dialog_type_item_text.setTextColor((Color.parseColor("#1DA1F2")))
            im_expert_info_dialog_type_item_text.typeface = Typeface.defaultFromStyle(Typeface.BOLD)
            im_expert_info_dialog_type_item_text.setBackgroundResource(R.drawable.im_expert_info_dialog_type_item_selected_bg)
        } else {
            im_expert_info_dialog_type_item_text.setTextColor((Color.parseColor("#999999")))
            im_expert_info_dialog_type_item_text.typeface = Typeface.defaultFromStyle(Typeface.NORMAL)
            im_expert_info_dialog_type_item_text.setBackgroundResource(R.drawable.im_expert_info_dialog_type_item_unselected_bg)
        }
    }
}