package com.ydl.js

import android.annotation.SuppressLint
import android.app.Activity
import android.content.Context
import android.text.TextUtils
import com.alibaba.android.arouter.facade.annotation.Route
import com.google.gson.Gson
import com.tencent.smtt.sdk.WebView
import com.ydl.audioim.api.IAudioImService
import com.ydl.webview.*
import com.ydl.ydlcommon.modular.findRouteService
import com.ydl.ydlcommon.utils.Utils
import com.yidianling.common.tools.ToastUtil
import com.yidianling.ydl_pay.pay.payDialog.CallBack
import com.yidianling.ydl_pay.pay.payDialog.ConfidePayParams
import com.yidianling.ydl_pay.pay.payDialog.PayDialog

/**
 * Created by haorui on 2019-10-10.
 * Des:
 */
@Route(path = "/web/webservice")
class WebServiceImpl : IWebService {

    override fun getJavascripHandler(activity: Activity, webView:WebView?, tellData: TellData): IJavascriptHandler {
        return NewH5_JavascriptHandler(webView, object : NewH5_WVClickAbstractListener(activity) {

            override fun setTitle(jsData: H5JsBean.H5JsCmd.Params?) {
                //设置webview标题
                if (activity is NewH5Activity) {
                    activity.setWebViewTitle(jsData?.title)
                }
            }

            //倾诉链接java接口
            override fun confideConnect(jsData: H5JsBean.H5JsCmd.Params?) {
                if (Utils.isFastClick()) {
                    //防止连击
                    return
                }
                if (!findRouteService(IAudioImService::class.java).getIsOnlineRtm()) {
                    //异常退出或者账号被顶掉，重新登录并拨打
                    findRouteService(IAudioImService::class.java).loginRtm(JsModularService.getIUserService().getUserInfo()?.uid) { isSuccess: Boolean, _ ->
                        if (isSuccess) {
                            connectionJava(jsData?.id ?: 0, jsData?.confideType ?: 1, activity, tellData, jsData?.callType)
                        } else {
                            ToastUtil.toastShort("请重新拨打")
                        }
                    }
                } else {
                    connectionJava(jsData?.id ?: 0, jsData?.confideType ?: 1, activity, tellData, jsData?.callType)
                }
            }

            //php线路已废除
            override fun listenTel(jsData: H5JsBean.H5JsCmd.Params?) {
            }

            override fun listenAgora(jsData: H5JsBean.H5JsCmd.Params?) {
                if (Utils.isFastClick()) {
                    //防止连击
                    return
                }
                //声网路线
                connectionJava(jsData?.id ?: 0, 3, activity, tellData, jsData?.callType)
            }

            override fun confidePay(jsData: H5JsBean.H5JsCmd.Params?) {
                //倾诉支付
                val confidePay = ConfidePayParams(
                    jsData?.payTitle ?: "倾诉服务", jsData?.orderPrice, jsData?.coupnPrice ?: 0.00,
                    jsData?.avliableMoney ?: 0.00, jsData?.payId ?: "", jsData?.confideUrl ?: "", jsData?.merchantType
                )
                confidePayDialog(jsData?.id, jsData?.confideType, activity, confidePay, jsData?.callType)
            }

            override fun back() {
                if (activity is NewH5Activity) {
                    activity.goBack()
                }
            }
        })
    }

    //倾诉支付弹窗
    private fun confidePayDialog(id: Int?, type : Int?, activity: Activity, confidePay : ConfidePayParams, callType:String?){
        PayDialog(activity)
            .setCallback(object : CallBack {
                override fun onSuccess() {
                    //支付成功，直接拨打
                    if (TextUtils.isEmpty(confidePay.confideUrl)) {
                        connectionJava(id ?: 0, type ?: 1, activity, null, callType)
                    } else {
                        //倾诉订单列表页面过来，会有confideUrl值，则直接跳转此url
                        NewH5Activity.start(activity, H5Params(confidePay.confideUrl!!, ""))
                    }
                }
                override fun onError() {
                }

            })
            .show(confidePay)
    }

    //java版axb和声网接口
    @SuppressLint("CheckResult")
    private fun connectionJava(id: Int, type: Int, activity: Activity, tellData: TellData?, callType: String?) {
        try {
            JsModularService.getIConfideService().connectionJava(
                id, type, activity, Gson().toJson(tellData), callType
            )
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    override fun init(context: Context) {

    }
}
