package com.ydl.js.http

import com.ydl.js.bean.TimeDataBean
import com.ydl.ydlcommon.data.http.BaseResponse
import com.ydl.ydlnet.YDLHttpUtils
import io.reactivex.Observable

class JsHttpImpl private constructor() : JsHttp{
     companion object {
         fun getInstance(): JsHttpImpl {
             return Holder.INSTANCE
         }

         fun clearAppApi() {
             Holder.INSTANCE.appApi = null
         }

     }
     private var appApi: JsApi? = null
     private fun getAppApi(): JsApi {
         if (appApi == null) {
             appApi = YDLHttpUtils.obtainApi(JsApi::class.java)
         }

         return appApi!!
     }
     object Holder {
         val INSTANCE = JsHttpImpl()
     }

    override fun getTimePickerData(
        day: String,
        doctorId: String,
        orderId: String
    ): Observable<BaseResponse<ArrayList<TimeDataBean>>> {
        return getAppApi().getTimePickerData(day,doctorId,orderId)
    }
}