package com.yidianling.muse.utils

import android.app.Activity
import android.content.Context
import android.content.Intent
import android.net.Uri
import android.provider.Settings

object MeditationFloatPermissionUtil {

    const val REQUEST_FLOAT_CODE=1001

    private fun commonROMPermissionCheck(context: Context?):Boolean {
        var result = true
        try {
            val clazz: Class<*> = Settings::class.java
            val canDrawOverlays = clazz.getDeclaredMethod("canDrawOverlays", Context::class.java)
            result = canDrawOverlays.invoke(null, context) as Boolean
        } catch (e: Exception) {

        }
        return result
    }

    fun checkSuspendedWindowPermission(context: Activity,block:() -> Unit){
        if(commonROMPermissionCheck(context)){
            block
        }else{
            context.startActivityForResult(Intent(Settings.ACTION_MANAGE_OVERLAY_PERMISSION).apply {
                data = Uri.parse("package:${context.packageName}")
            }, REQUEST_FLOAT_CODE)
        }
    }

}