package com.yidianling.muse.widget


import android.app.Activity
import android.os.Bundle
import android.util.DisplayMetrics
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.view.ViewGroup.LayoutParams.MATCH_PARENT
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.TextView
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.fragment.app.DialogFragment
import com.bumptech.glide.Glide
import com.umeng.socialize.bean.SHARE_MEDIA
import com.ydl.ydlcommon.actions.share.ShareUtils
import com.yidianling.muse.R
import com.yidianling.muse.utils.ShareMeditationUtil
import kotlinx.android.synthetic.main.layout_share_play_meditation.*


class ShareMeditationDialog : DialogFragment() {

    private var ivSharePicture: ImageView? = null
    private var tvShareContent: TextView? = null

    private var llWeChat: LinearLayout? = null
    private var llCircleOfFriends: LinearLayout? = null
    private var llSave: LinearLayout? = null
    private var llQQZone: LinearLayout? = null
    private var llQQFriend: LinearLayout? = null

    private var cslLayout: ConstraintLayout?=null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setStyle(STYLE_NO_TITLE, R.style.share_meditation_dialog)
    }

    override fun onStart() {
        super.onStart()
        val displayMetrics = DisplayMetrics()
        activity?.windowManager?.defaultDisplay?.getMetrics(displayMetrics)
        val window = dialog?.window
        window?.setLayout(MATCH_PARENT, MATCH_PARENT)
    }

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        val view = inflater.inflate(R.layout.layout_share_meditation_dialog, container)
        initView(view)
        return view
    }

    private fun initView(view: View?) {

        val shareImageUrl = arguments?.getString(KEY_SHARE_IMAGE_URL) ?: ""
        val shareTitle = arguments?.getString(KEY_SHARE_TITLE) ?: ""
        val shareContent = arguments?.getString(KEY_SHARE_CONTENT) ?: ""
        val shareUrl = arguments?.getString(KEY_SHARE_URL) ?: ""
        val shareMiniId = arguments?.getString(KEY_SHARE_MINI_ID) ?: ""
        val shareMiniPath = arguments?.getString(KEY_SHARE_MINI_PATH) ?: ""

        ivSharePicture = view?.findViewById(R.id.iv_share_picture)

        tvShareContent = view?.findViewById(R.id.tv_share_content)

        if (view != null && ivSharePicture != null) {
            Glide.with(view.context)
                .load(shareImageUrl)
                .into(ivSharePicture!!)
        }

        llWeChat = view?.findViewById(R.id.ll_wechat_friend)
        llCircleOfFriends = view?.findViewById(R.id.ll_wechat_circle_of_friends)
        llSave = view?.findViewById(R.id.ll_save_picture)
        llQQZone = view?.findViewById(R.id.ll_qq_zone)
        llQQFriend = view?.findViewById(R.id.ll_qq_friend)
        cslLayout = view?.findViewById(R.id.csl_root_layout)

        cslLayout?.setOnClickListener {
            dismiss()
        }

        llWeChat?.setOnClickListener {
            ShareUtils.shareSmailWeixin(
                activity as Activity,
                shareTitle,
                shareUrl,
                shareContent,
                shareImageUrl,
                path = shareMiniPath,
                id = shareMiniId,
                shareListener = null
            )
            dismiss()
        }

        llCircleOfFriends?.setOnClickListener {
            ShareUtils.shareTo(
                SHARE_MEDIA.WEIXIN_CIRCLE,
                activity as Activity,
                shareTitle,
                shareUrl,
                shareContent,
                shareImageUrl
            )
            dismiss()
        }

        llSave?.setOnClickListener {
            ShareMeditationUtil.saveImageToLocal(csl_layout_top)
            dismiss()
        }

        llQQZone?.setOnClickListener {
            ShareUtils.shareTo(
                SHARE_MEDIA.QZONE,
                activity as Activity,
                shareTitle,
                shareUrl,
                shareContent,
                shareImageUrl
            )
            dismiss()
        }

        llQQFriend?.setOnClickListener {
            ShareUtils.shareTo(
                SHARE_MEDIA.QQ,
                activity as Activity,
                shareTitle,
                shareUrl,
                shareContent,
                shareImageUrl
            )
            dismiss()
        }

        view?.findViewById<TextView>(R.id.tv_cancel_share)?.setOnClickListener {
            dismiss()
        }

    }

    companion object {
        const val TAG = "ShareMeditationDialog"

        private const val KEY_SHARE_TITLE = "key_share_title"
        private const val KEY_SHARE_URL = "key_share_url"
        private const val KEY_SHARE_CONTENT = "key_share_content"
        private const val KEY_SHARE_IMAGE_URL = "key_share_image_url"
        private const val KEY_SHARE_MINI_ID = "key_share_mini_id"
        private const val KEY_SHARE_MINI_PATH = "key_share_mini_path"

        fun newInstance(
            shareTitle: String,
            shareUrl: String,
            shareContent: String,
            shareImageUrl: String,
            miniId: String,
            miniPath: String
        ): ShareMeditationDialog {
            val args = Bundle()
            args.putString(KEY_SHARE_TITLE, shareTitle)
            args.putString(KEY_SHARE_CONTENT, shareContent)
            args.putString(KEY_SHARE_URL, shareUrl)
            args.putString(KEY_SHARE_IMAGE_URL, shareImageUrl)
            args.putString(KEY_SHARE_MINI_ID, miniId)
            args.putString(KEY_SHARE_MINI_PATH, miniPath)
            val fragment = ShareMeditationDialog()
            fragment.arguments = args
            return fragment
        }

    }

}