package com.yidianling.tests

import android.annotation.SuppressLint
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.BaseAdapter
import android.widget.ImageView
import android.widget.TextView
import com.alibaba.android.arouter.facade.annotation.Route
import com.ydl.ydl_image.module.GlideApp
import com.ydl.ydl_image.transform.GlideCircleTransform
import com.ydl.ydlcommon.base.BaseActivity
import com.ydl.ydlcommon.router.YdlCommonOut
import com.ydl.ydlcommon.utils.NetworkParamsUtils
import com.ydl.ydlcommon.utils.remind.HttpErrorUtils
import com.ydl.ydlcommon.view.dialog.NormalDialog
import com.yidianling.common.tools.ToastUtil
import com.yidianling.im.api.bean.IMRequestCallback
import com.yidianling.tests.home.param.RecentCmd
import com.yidianling.tests.router.TestsIn
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.schedulers.Schedulers
import kotlinx.android.synthetic.main.tests_activity_select_conversation.*
import java.util.*

/**
 * Created by Wi1ls on 2016/11/10;
 */
@Route(path = "/test/select_conversation")
class SelectConversationActivity : BaseActivity() {
    override fun layoutResId(): Int {
        return R.layout.tests_activity_select_conversation
    }

    override fun initDataAndEvent() {
        url = getIntent().getStringExtra("url")
        head = getIntent().getStringExtra("head")
        title = getIntent().getStringExtra("title")
        share_url = getIntent().getStringExtra("share_url")
        id = getIntent().getIntExtra("id", 0)
        flag = getIntent().getIntExtra("flag", 0)

        init()
    }

//    internal var text_empty: TextView? = null

    internal var url: String? = null
    internal var head: String? = null
    internal var title: String? = null
    internal var share_url: String? = null
    internal var id: Int = 0
    internal var flag: Int = 0

    private var myData: MutableList<RecentExpert> = ArrayList<RecentExpert>()

    internal fun init() {
        getData()
    }

    @SuppressLint("WrongConstant")
    private fun handleData() {
            text_empty.visibility = View.INVISIBLE
            select_lv.visibility = View.VISIBLE
            val conversationAdapter = object : BaseAdapter() {
                override fun getCount(): Int {
                    return myData.size
                }

                override fun getItem(position: Int): Any {
                    return myData[position]
                }

                override fun getItemId(position: Int): Long {
                    return position.toLong()
                }

                override fun getView(position: Int, convertView: View?, parent: ViewGroup?): View {
                    val view = LayoutInflater.from(mContext).inflate(R.layout.tests_ui_select_conversation_item, null, false)
                    val s = view.findViewById<ImageView>(R.id.sdv_head) as ImageView
                    val n = view.findViewById<TextView>(R.id.name) as TextView
                    GlideApp.with(mContext)
                            .load(myData[position].getHead())
                            .transform(GlideCircleTransform(mContext))
                            .centerCrop()
                            .into(s)
                    n.text = myData[position].name
                    view.setOnClickListener {
                        val builder = NormalDialog.Builder(mContext)
                        builder.setTitle("")
                        builder.setMessage("确定将测试结果发送给：" + myData[position].name + "？")
                        builder.setPositiveButton("确定"
                        ) { dialog, which ->
                            TestsIn.sendTestResultMessage(myData[position].uid, "测试结果", title, head, url, id, share_url,
                                    object : IMRequestCallback<Void> {
                                        override fun onSuccess(t: Void?) {
                                            YdlCommonOut.showToast("发送成功")

                                            finish()
                                        }

                                        override fun onFailed(i: Int) {
                                            YdlCommonOut.showToast("发送失败")
                                            finish()
                                        }

                                        override fun onException(throwable: Throwable?) {
                                            YdlCommonOut.showToast("发送失败")
                                            finish()
                                        }
                                    })
                            dialog.dismiss()
                        }
                        builder.setNegativeButton("取消"
                        ) { dialog, _ -> dialog.dismiss() }
                        builder.create().show()
                    }
                    return view
                }
            }
            select_lv.adapter = conversationAdapter
    }

    private fun getData() {
        val cmd = RecentCmd()
        TestRetrofitApi.getTestRetrofitApi().getRecentExpertList(NetworkParamsUtils.getMaps(cmd))
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .doOnSubscribe({showProgressDialog("")})
                .doAfterTerminate({dismissProgressDialog()})
                .subscribe(
                        {
                            if (it.code == 0) {
                                for (recent in it.data) {
                                    val recentExpert = RecentExpert(""+recent.uid, recent.head, recent.name)
                                    myData.add(recentExpert)
                                }
                                handleData()
                            } else {
                                ToastUtil.toastShort(this@SelectConversationActivity, it.msg)
                            }
                        },{
                            HttpErrorUtils.handleError(mContext,it)
                        })
    }

    companion object {
        val FLAG_SEND_TESTRESULT = 1
    }


}
