package com.yidianling.tests.home.adapter

import android.content.Context
import androidx.recyclerview.widget.RecyclerView
import android.view.View
import android.view.ViewGroup
import com.yidianling.tests.R
import com.yidianling.tests.home.bean.TestHomeDataBean
import com.yidianling.tests.home.config.ITestHomeConfig
import com.yidianling.tests.home.contract.ITestHomeContract
import com.yidianling.tests.home.event.ITestHomeEvent
import com.yidianling.tests.home.widget.*
import java.util.*

/**
 * @author yuanwai
 * @描述:测评首页列表适配器
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/7/27
 */
class TestHomeAdapter(private val mContext: Context,
                      private var mListData: List<TestHomeDataBean>,
                      private var testHomeEvent: ITestHomeEvent,
                      private var testHomeView: ITestHomeContract.View) : RecyclerView.Adapter<RecyclerView.ViewHolder>() {

    private var categoryViewHolder: CategoryViewHolder? = null
    private var bannerViewHolder: BannerViewHolder? = null
    var couponMoney = ""

    override fun getItemViewType(position: Int): Int {
        if (ITestHomeConfig.TYPE_RECOMMENDED == mListData[position].type!!) {
            if (mListData[position].body!![0].recommendIsFirst!!) {
                return ITestHomeConfig.TYPE_RECOMMENDED_FIRST
            }
        }
        return mListData[position].type!!
    }

    fun updataItems(list: List<TestHomeDataBean>) {
        if (null == mListData || mListData.isEmpty()) {
            mListData = ArrayList()
        } else {
            (mListData as ArrayList).clear()
        }
        (mListData as ArrayList).addAll(list)

    }

    fun setBannerRefresh(){
        if (null != bannerViewHolder && null != bannerViewHolder!!.bannerView!!) {
            bannerViewHolder!!.bannerView!!.setRefresh(false)
        }
    }

    fun addItems(list: List<TestHomeDataBean>) {
        if (null == mListData || mListData.isEmpty()) {
            mListData = ArrayList()
        }
        (mListData as ArrayList).addAll(list)
    }

    fun getList(): List<TestHomeDataBean> {
        return mListData
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        when (viewType) {
        //banner
            ITestHomeConfig.TYPE_BANNER -> {
                return BannerViewHolder(TestHomeBannerView(parent.context, testHomeEvent))
            }
        //分类测评+实时测试状态
            ITestHomeConfig.TYPE_CATEGORY -> {
                return CategoryViewHolder(TestHomeCategoryView(parent.context, testHomeEvent))
            }
        //每日精选
            ITestHomeConfig.TYPE_DAILY -> {
                return DailyViewViewHolder(TestHomeDailyView(parent.context, testHomeEvent, testHomeView))
            }
        //推荐测评列表
            ITestHomeConfig.TYPE_RECOMMENDED -> {
                return RecommendedViewHolder(TestHomeRecommendedView(parent.context, testHomeEvent))
            }
            ITestHomeConfig.TYPE_RECOMMENDED_FIRST -> {
                return RecommendedFirstViewHolder(TestHomeRecommendedFirstView(parent.context, testHomeEvent))
            }
            else -> {
                return EmptyViewHolder(View.inflate(parent.context, R.layout.tests_testhome_empty, null))
            }
        }
    }

    override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) =
            if (holder is BannerViewHolder && null != holder.bannerView) {
                bannerViewHolder = holder
                holder.bannerView!!.initData(mListData[position])
            } else if (holder is CategoryViewHolder && null != holder.categoryView) {
                categoryViewHolder = holder
                holder.categoryView!!.initData(mListData[position])
            } else if (holder is DailyViewViewHolder && null != holder.dailyView) {
                holder.dailyView!!.couponMoney = couponMoney
                holder.dailyView!!.initData(mListData[position])
            } else if (holder is RecommendedFirstViewHolder) {
                holder.recommendedFirstView!!.couponMoney = couponMoney
                holder.recommendedFirstView!!.initData(mListData[position], position)
            } else if (holder is RecommendedViewHolder && null != holder.recommendedView) {
                holder.recommendedView!!.couponMoney = couponMoney
                holder.recommendedView!!.initData(mListData[position], position)

            } else if (holder is EmptyViewHolder) {

            } else {

            }

    override fun getItemCount(): Int {
        return mListData.size
    }

    /**
     * Banner viewHolder
     */
    inner class BannerViewHolder(itemView: TestHomeBannerView) : RecyclerView.ViewHolder(itemView) {

        var bannerView: TestHomeBannerView? = null

        init {
            bannerView = itemView
        }
    }

    /**
     * 测评分类+实时测试状态viewHolder
     */
    inner class CategoryViewHolder(itemView: TestHomeCategoryView) : RecyclerView.ViewHolder(itemView) {
        var categoryView: TestHomeCategoryView? = null

        init {
            categoryView = itemView
        }
    }

    /**
     * 每日精选 viewHolder
     */
    inner class DailyViewViewHolder(itemView: TestHomeDailyView) : RecyclerView.ViewHolder(itemView) {
        var dailyView: TestHomeDailyView? = null

        init {
            dailyView = itemView
        }
    }

    /**
     * 热门推荐 第一个view的 viewHolder
     */
    inner class RecommendedFirstViewHolder(itemView: TestHomeRecommendedFirstView) : RecyclerView.ViewHolder(itemView) {
        var recommendedFirstView: TestHomeRecommendedFirstView? = null

        init {
            recommendedFirstView = itemView
        }
    }

    /**
     * 热门推荐viewHolder
     */
    inner class RecommendedViewHolder(itemView: TestHomeRecommendedView) : RecyclerView.ViewHolder(itemView) {
        var recommendedView: TestHomeRecommendedView? = null

        init {
            recommendedView = itemView
        }
    }

    /**
     * 空ViewHolder
     */
    inner class EmptyViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        var view: View? = null

        init {
            view = itemView
        }
    }

    fun starBanner() {
        if (null != bannerViewHolder && null != bannerViewHolder!!.bannerView) {
            bannerViewHolder!!.bannerView!!.startBanner()
        }
    }

    fun stopBanner() {
        if (null != bannerViewHolder && null != bannerViewHolder!!.bannerView) {
            bannerViewHolder!!.bannerView!!.stopBanner()
        }
    }

    fun onDestory() {
        //暂停 实施测评状态轮播
        if (null != categoryViewHolder && null != categoryViewHolder!!.categoryView) {
            categoryViewHolder!!.categoryView!!.onDestory()
        }
        //暂停 banner轮播
        if (null != bannerViewHolder && null != bannerViewHolder!!.bannerView) {
            bannerViewHolder!!.bannerView!!.stopBanner()
        }
    }
}