package com.yidianling.tests.home.event

/**
 * @author yuanwai
 * @描述:测评首页点击事件接口类
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/8/3
 */
interface ITestHomeEvent {
    /**
     * 跳转我的界面
     */
    fun jumpMine()

    /**
     * 跳转搜索界面
     */
    fun jumpSearch()

    /**
     * banner点击事件
     */
    fun bannerClick(linkUrl: String?, position: Int, title: String?)

    /**
     * 测评分类点击事件
     * @param tabName 标签名称
     */
    fun categoryClick(tabName: String?, position: Int, title: String?,id: String?)

    /**
     * 实时测评状态点击事件
     */
    fun realTestClick(linkUrl: String?, title: String?)

    /**
     * 每日精选点击事件
     */
    fun dailyClick(linkUrl: String?, position: Int, title: String?)

    /**
     * 热门推荐点击事件
     */
    fun recommendedClick(linkUrl: String?, position: Int, title: String?)

    /**
     * 查看全部测评
     */
    fun selectAll()
}