package com.yidianling.tests.home.widget

import android.content.Context
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout
import com.ydl.ydlcommon.view.banner.GlideImageLoader
import com.yidianling.common.tools.RxImageTool
import com.yidianling.tests.R
import com.yidianling.tests.home.bean.TestHomeBodyBean
import com.yidianling.tests.home.bean.TestHomeDataBean
import com.yidianling.tests.home.event.ITestHomeEvent
import kotlinx.android.synthetic.main.tests_testhome_banner_view.view.*

/**
 * @author yuanwai
 * @描述:测评首页banner
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/7/27
 */
class TestHomeBannerView(context: Context?, testHomeEvent: ITestHomeEvent) : FrameLayout(context) {
    /**
     * banner数据缓存
     */
    private var mDataList: List<TestHomeBodyBean>? = null
    /**
     * 数据缓存
     */
    private var mDataBean: TestHomeDataBean? = null

    private var testHomeEvent: ITestHomeEvent? = null

    private var dp14 = 0
    private var dp4 = 0
    private var margin = 0

    private var isRefresh: Boolean? = false

    init {
        this.testHomeEvent = testHomeEvent
        initView()
    }

    private fun initView() {
        val params = FrameLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT)
        View.inflate(context, R.layout.tests_testhome_banner_view, this)
        layoutParams = params
        dp14 = RxImageTool.dip2px(14f)
        dp4 = RxImageTool.dip2px(4f)
        margin = RxImageTool.dip2px(2.5f)
    }

    fun setRefresh(isRefresh: Boolean) {
        this.isRefresh = isRefresh
    }

    fun initData(dataBean: TestHomeDataBean) {
        if (isRefresh!!) {
            return
        }
        isRefresh = true
        if (null == dataBean ||
                (dataBean.body == null && null == dataBean.category) ||
                (dataBean.body!!.isEmpty() && dataBean.category!!.isEmpty())) {
            visibility = View.GONE
            return
        }
        mDataBean = dataBean

        visibility = View.VISIBLE

        if (null == mDataList) {
            mDataList = ArrayList()
        } else {
            (mDataList as ArrayList).clear()
        }
        (mDataList as ArrayList<TestHomeBodyBean>).addAll(mDataBean!!.body!!)

        var urlLists = ArrayList<String>()
        var count = (mDataList as ArrayList<TestHomeBodyBean>).size - 1
        for (index in 0..count) {
            urlLists.add((mDataList as ArrayList<TestHomeBodyBean>)[index].bannerImageUrl!!)
        }
        banner.setImageLoader(GlideImageLoader(R.drawable.tests_testhome_banner_nor)).setImages(urlLists).start()

        banner.setOnBannerListener {
            testHomeEvent!!.bannerClick((mDataList as ArrayList<TestHomeBodyBean>)[it].bannerLinkUrl, it, (mDataList as ArrayList<TestHomeBodyBean>)[it].bannerName)
        }
//        initAdapter()
//        initTimer()
    }

//    /**
//     * 更新适配器
//     */
//    private fun initAdapter() {
//        isInitFinish = false
//
//        if (null == bannerAdapter) {
//            bannerAdapter = TestHomeBannerAdapter(mDataList as ArrayList<TestHomeBodyBean>, context, testHomeEvent!!)
//            viewPager.adapter = bannerAdapter
//        } else {
//            bannerAdapter!!.updataItems(mDataList as ArrayList<TestHomeBodyBean>)
//        }
//        viewPager.addOnPageChangeListener(object : ViewPager.OnPageChangeListener {
//            override fun onPageScrolled(position: Int, positionOffset: Float, positionOffsetPixels: Int) {
//            }
//
//            override fun onPageSelected(position: Int) {
//                countImg = position
//                setImageBackground(position % tips!!.size)
//            }
//
//            override fun onPageScrollStateChanged(state: Int) {
//            }
//
//        })
//        updataPoint()
//        isInitFinish = true
//        countImg = 0
//    }
//
//    /**
//     * 更新viewpager 指示器原点
//     */
//    private fun updataPoint() {
//        if (null == tips) {
//            tips = ArrayList()
//        } else {
//            (tips as ArrayList).clear()
//        }
//        ll_tips!!.removeAllViews()
//        var index = 0
//        var imageWidth = 0
//        for (item in mDataList!!) {
//            val imageView = ImageView(context)
//
//            if (index == 0) {
//                imageWidth = dp14
//                imageView.setBackgroundResource(R.drawable.tests_testhome_tip_select)
//            } else {
//                imageWidth = dp4
//                imageView.setBackgroundResource(R.drawable.tests_testhome_tip_unselect)
//            }
//            var layoutParams = LinearLayout.LayoutParams(imageWidth, dp4)
//            imageView.scaleType = ImageView.ScaleType.FIT_XY
//            layoutParams.leftMargin = margin
//            layoutParams.rightMargin = margin
//            imageView.layoutParams = layoutParams
//            index++
//            (tips as ArrayList<ImageView>).add(imageView)
//            ll_tips!!.addView(imageView)
//        }
//    }
//
//    /**
//     * 改变图片
//     */
//    private fun setImageBackground(selectItems: Int) {
//        var count = tips!!.size
//        var imageWidth = 0
//        for (i in 0..count) {
//            var imageView = ll_tips!!.getChildAt(i)
//            if (null == imageView) {
//                return
//            }
//            if (imageView !is ImageView) {
//                return
//            }
//            if (i == selectItems) {
//                imageWidth = dp14
//                imageView.setBackgroundResource(R.drawable.tests_testhome_tip_select)
//            } else {
//                imageWidth = dp4
//                imageView.setBackgroundResource(R.drawable.tests_testhome_tip_unselect)
//            }
//            var params = LinearLayout.LayoutParams(imageWidth, dp4)
//            params.leftMargin = margin
//            params.rightMargin = margin
//            imageView.layoutParams = params
//        }
//    }
//
//    override fun dispatchTouchEvent(ev: MotionEvent): Boolean {
//        val action = ev.action
//        if (action == MotionEvent.ACTION_DOWN) {
//            timeDown = System.currentTimeMillis()
//            viewPager.isClick = true
//        } else if (action == MotionEvent.ACTION_UP) {
//            timeUp = System.currentTimeMillis()
//            viewPager.isClick = false
//        }
//        return super.dispatchTouchEvent(ev)
//    }

//    private var dcTime = 0
//
//    private fun initTimer() {
//        //计时,如果没有用户干预,每5秒进行vp操作,
//        if (null != mTimer) {
//            dcTime = 0
//            mTimer!!.cancel()
//        }
//        mTimer = Timer(true)
//        mTimer!!.schedule(object : TimerTask() {
//            override fun run() {
//                if (isNeedStop) {
//                    return
//                }
//                dcTime++
//                if (dcTime % 5 == 0) {
//                    updateUI()
//                }
//            }
//        }, 0, 1000)
//    }

//    internal fun updateUI() {
//        if (!isInitFinish)
//            return
//
//        Observable.just(0)
//                .observeOn(AndroidSchedulers.mainThread())
//                .subscribe { integer ->
//
//                    countImg++
//                    countImg %= if (bannerAdapter!!.count == 0) 1 else bannerAdapter!!.count
//                    viewPager.currentItem = countImg
//                }
//    }

    fun startBanner() {
        if (banner != null) {
            banner.startAutoPlay()
        }
    }

    fun stopBanner() {
        if (banner != null) {
            banner.stopAutoPlay()
        }
    }
}