package com.yidianling.tests.home.widget

import android.content.Context
import android.graphics.Color
import androidx.cardview.widget.CardView
import android.text.TextUtils
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import com.ydl.ydl_image.module.GlideApp
import com.yidianling.common.tools.RxImageTool
import com.yidianling.tests.R
import com.yidianling.tests.home.bean.TestHomeBodyBean
import com.yidianling.tests.home.event.ITestHomeEvent
import com.yidianling.tests.home.utils.TestHomeUtils
import kotlinx.android.synthetic.main.tests_testhome_dailyitem_view.view.*

/**
 * @author yuanwai
 * @描述:每日精选itemView
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/8/1
 */
class TestHomeDailyHorizoItemView(mContext: Context, testHomeEvent: ITestHomeEvent, isRight: Boolean) : CardView(mContext) {
    /**
     * 测评首页事件处理类
     */
    private var testHomeEvent: ITestHomeEvent? = null
    private var isRight: Boolean? = false
    var couponMoney = ""
    init {
        this.testHomeEvent = testHomeEvent
        this.isRight = isRight
        initView()
    }

    /**
     * 界面初始化
     */
    private fun initView() {
        var params = LinearLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT)
        View.inflate(context, R.layout.tests_testhome_dailyitem_view, this)
        var dp6 = RxImageTool.dip2px(6f)
        if (isRight!!) {
            params.setMargins(dp6, RxImageTool.dip2px(5f), RxImageTool.dip2px(15f), RxImageTool.dip2px(5f))
        } else {
            params.setMargins(dp6, RxImageTool.dip2px(5f), dp6, RxImageTool.dip2px(5f))
        }
        layoutParams = params
        radius = RxImageTool.dip2px(6f).toFloat()
        cardElevation = RxImageTool.dip2px(2f).toFloat()
    }

    /**
     * 设置数据
     */
    fun initData(bodyBean: TestHomeBodyBean, position: Int) {
        GlideApp.with(context).load(bodyBean.dailyImageUrl)
                .placeholder(R.drawable.tests_testhome_list_nor)
                .centerCrop().into(img_icon)
        tv_title.text = bodyBean.dailyTitle
        tv_content.text = TestHomeUtils.getNum(context, bodyBean.dailyContent)
        setPrice(bodyBean.price)
        setOnClickListener {
            testHomeEvent!!.dailyClick(bodyBean.dailyLinkUrl, position, bodyBean.dailyTitle)
        }
    }

    private fun setPrice(price : String?){
        if (TextUtils.isEmpty(price)){
            tv_price.visibility = View.INVISIBLE
            return
        }
        tv_price.visibility = View.VISIBLE
        
        if (price.equals("免费")
                ||TextUtils.isEmpty(price)
                || "0" == price
                || "0.0" == price
                || "0.00" == price){
            tv_price.text = "免费"
            tv_price.setBackgroundResource(R.drawable.tests_testhome_recom_price_bg)
            tv_price.setTextColor(Color.parseColor("#34CD65"))
        } else {
            var newPrice = TestHomeUtils.getOriginalPrice(tv_coupon_money,price,couponMoney)
            var priceContent = "￥$newPrice"
            TestHomeUtils.priceStyleNew(context, tv_price, priceContent, 1, priceContent.length)
            tv_price.setBackgroundResource(R.drawable.tests_testhome_null)
        }
    }
}