package com.yidianling.tests.home.widget

import android.content.Context
import android.view.View
import android.view.ViewGroup
import android.widget.RelativeLayout
import com.yidianling.common.tools.RxImageTool
import com.yidianling.tests.R
import com.yidianling.tests.home.bean.TestHomeDataBean
import com.yidianling.tests.home.contract.ITestHomeContract
import com.yidianling.tests.home.event.ITestHomeEvent
import kotlinx.android.synthetic.main.tests_testhome_daily_view.view.*

/**
 * @author yuanwai
 * @描述:测评首页--每日精选View
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/7/27
 */
class TestHomeDailyView(mContext: Context,
                        testHomeEvent: ITestHomeEvent,
                        testHomeView: ITestHomeContract.View
)
    : RelativeLayout(mContext) {
    /**
     * 数据缓存
     */
    private var mDataBean: TestHomeDataBean? = null

    private var mView: View? = null

    private var testHomeEvent: ITestHomeEvent? = null

    private var testHomeView: ITestHomeContract.View? = null
    /**
     * 底部线是否添加
     */
    private var hasLine: Boolean = false
    var couponMoney = ""

    init {
        this.testHomeView = testHomeView
        this.testHomeEvent = testHomeEvent
        initView()
    }

    /**
     * 界面初始化
     */
    private fun initView() {
        var params = RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT)
        layoutParams = params
        mView = View.inflate(context, R.layout.tests_testhome_daily_view, this)
        tests_testhome_dailyRight.setOnClickListener {
            testHomeView!!.dailyChange()
        }
    }

    /**
     * 设置数据
     */
    fun initData(dataBean: TestHomeDataBean) {
        //如果数据为空 隐藏当前View
        if (null == dataBean || null == dataBean.body || dataBean.body.isEmpty()) {
            visibility = View.GONE
            return
        }
        visibility = View.VISIBLE
        mDataBean = dataBean
        refreshView()
    }

    /**
     * 界面刷新
     */
    fun refreshView() {
        //标题赋值
        createTitle()
        //列表赋值
        createDailyHorizo()
        addBottomLine()
    }


    /**
     * 创建标题
     */
    private fun createTitle() {
        if (null == mDataBean) {
            tv_title.text = ""
            return
        }
        tv_title.text = mDataBean!!.head!!.title
    }

    /**
     * 创建每日精选横向滚动View
     */
    private fun createDailyHorizo() {
        var dailyHorizoView = getChildAt(childCount - 2)
        if (dailyHorizoView is TestHomeDailyHorizoView) {
            dailyHorizoView.couponMoney = this.couponMoney
            dailyHorizoView.initData(mDataBean!!.body!!)
        } else {
            var params = RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT)
            dailyHorizoView = TestHomeDailyHorizoView(context, testHomeEvent!!)
            dailyHorizoView.id = R.id.tests_testhome_daily
            dailyHorizoView.couponMoney = this.couponMoney
            dailyHorizoView.initData(mDataBean!!.body!!)
            params.addRule(BELOW, R.id.tv_title)
            params.leftMargin = RxImageTool.dip2px(9f)
            dailyHorizoView.layoutParams = params
            addView(dailyHorizoView)
        }
    }

    /**
     * 添加底部灰色线
     */
    private fun addBottomLine() {
        if (!hasLine) {
            hasLine = true
            var param = RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, RxImageTool.dip2px(9f))
            var bottomLine = View(context)
            bottomLine.setBackgroundColor(resources.getColor(R.color.tests_testhome_line))
            param.addRule(BELOW, R.id.tests_testhome_daily)
            bottomLine.layoutParams = param
            addView(bottomLine)
        }
    }
}