package com.yidianling.tests.home.widget

import android.content.Context
import android.graphics.Color
import android.text.TextUtils
import android.util.TypedValue
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout
import android.widget.LinearLayout
import android.widget.TextView
import com.ydl.ydl_image.module.GlideApp
import com.ydl.ydlcommon.utils.ScreenUtil
import com.yidianling.common.tools.LogUtil
import com.yidianling.common.tools.RxImageTool
import com.yidianling.tests.R
import com.yidianling.tests.home.bean.TestHomeBodyBean
import com.yidianling.tests.home.bean.TestHomeDataBean
import com.yidianling.tests.home.event.ITestHomeEvent
import com.yidianling.tests.home.utils.TestHomeUtils
import kotlinx.android.synthetic.main.tests_testhome_recommend_first_view.view.*

/**
 * @author yuanwai
 * @描述:热门推荐列表第一个显示的View
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/8/3
 */
class TestHomeRecommendedFirstView(mContext: Context, testHomeEvent: ITestHomeEvent) : FrameLayout(mContext) {
    /**
     * 图片宽度
     */
    private var imgWidth = 0

    private var isAddTitle = false

    private var testHomeEvent: ITestHomeEvent? = null
    var couponMoney  = ""

    init {
        this.testHomeEvent = testHomeEvent
        initView()
    }

    /**
     * 界面初始化
     */
    private fun initView() {
        View.inflate(context, R.layout.tests_testhome_recommend_first_view, this)
        imgWidth = ScreenUtil.screenWidth - RxImageTool.dip2px(30f)
        initImageParam()
        addTitle()
    }

    private fun addTitle() {
        if (isAddTitle) {
            return
        }
        isAddTitle = true
        val params = FrameLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT)
        params.leftMargin = RxImageTool.dip2px(15f)
        params.topMargin = RxImageTool.dip2px(30f)
        val titleView = TextView(context)
        titleView.id = R.id.tests_testhome_recommenTitle
        titleView.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 18f)
        titleView.setTextColor(resources.getColor(R.color.tests_testhome_title))

        val drawable = resources.getDrawable(R.drawable.tests_testhome_hot)
        /// 这一步必须要做,否则不会显示.
        drawable.setBounds(0, 0, drawable.minimumWidth, drawable.minimumHeight)
        titleView.setCompoundDrawablesWithIntrinsicBounds(drawable, null, null, null)
        titleView.compoundDrawablePadding = RxImageTool.dip2px(5f)
        titleView.layoutParams = params
        addView(titleView)
    }

    fun initData(dataBean: TestHomeDataBean, position: Int) {
        if (null == dataBean || null == dataBean.body || dataBean.body.isEmpty()) {
            visibility = View.GONE
            return
        }
        //设置标题
        findViewById<TextView>(R.id.tests_testhome_recommenTitle).text = dataBean.head!!.title
        //设置推荐列表数据
        initRecommeded(dataBean.body!![0], position)
    }

    private fun initImageParam() {
        val params = LinearLayout.LayoutParams(imgWidth, imgWidth/2)
        img_recom.layoutParams = params
    }

    /**
     * 设置推荐列表数据
     */
    private fun initRecommeded(bodyBean: TestHomeBodyBean, position: Int) {
        tv_recomTitle.text = bodyBean.recommendedTitle
        tv_recomContent.text = bodyBean.recommendedContent
        setPrice(bodyBean.recommendedPrice)
        tv_recomNum.text = TestHomeUtils.getNum(context, bodyBean.recommendedNum)
        GlideApp.with(context).load(bodyBean.recommendedUrl).placeholder(R.drawable.tests_testhome_banner_nor)
                .into(img_recom)
        LogUtil.e("宽：${img_recom.measuredWidth}；高${img_recom.measuredHeight}")
        tv_Hits.text = TestHomeUtils.getHits(context, bodyBean.recommendedHits)

        setOnClickListener {
            testHomeEvent!!.recommendedClick(bodyBean.recommendedLinkUrl, position, bodyBean.recommendedTitle)
        }
    }

    private fun setPrice(price: String?) {
        if (TextUtils.isEmpty(price)) {
            tv_recomPrice.visibility = View.INVISIBLE
            return
        }
        tv_recomPrice.visibility = View.VISIBLE
        if ("免费" == price) {
            tv_recomPrice.text = price
            tv_recomPrice.setBackgroundResource(R.drawable.tests_testhome_recom_price_bg)
            tv_recomPrice.setTextColor(Color.parseColor("#34CD65"))
        } else {
            var newPrice = TestHomeUtils.getOriginalPrice(tv_coupon_money,price,couponMoney)
            var priceContent = "￥$newPrice"
            TestHomeUtils.priceStyleNew(context, tv_recomPrice, priceContent, 1, priceContent.length)
            tv_recomPrice.setBackgroundResource(R.drawable.tests_testhome_null)
        }
    }

    /**
     * 释放
     */
    fun onDestory() {
        isAddTitle = false
    }
}