package com.yidianling.tests.list.presenter

import android.annotation.SuppressLint
import com.ydl.ydlcommon.mvp.base.SimplePresenter
import com.ydl.ydlcommon.utils.NetworkParamsUtils
import com.yidianling.tests.TestRetrofitApi
import com.yidianling.tests.list.model.TestListCommand
import com.yidianling.tests.list.view.TestListFragmentView
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.schedulers.Schedulers

/**
 * TestListFragmentPresenter
 * Created by zqk on 17-11-22.
 */
class TestListFragmentPresenter : SimplePresenter<TestListFragmentView>() {
    @SuppressLint("CheckResult")
    fun fetchTestList(type: String?, currentPage: Int) {
        val cmd = TestListCommand()
        cmd.tab = type
        cmd.page = currentPage
        TestRetrofitApi.getTestRetrofitApi()
                .fetchTestList(NetworkParamsUtils.getMaps(cmd))
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe({ resp ->
                    mView.dismissLoading()
                    if (resp.code == 0) {
                        mView.onTestListFetched(resp.data, currentPage)
                    } else {
                        mView.onFailed(resp.msg)
                    }
                }, { t ->
                    mView.onError(t)
                })

    }
}