package com.yidianling.tests.router

import android.app.Activity
import android.content.Context
import android.content.Intent
import com.ydl.ydlcommon.modular.ModularServiceManager
import com.ydl.ydlcommon.router.YdlUserInfo
import com.yidianling.dynamic.api.IDynamicService
import com.yidianling.im.api.bean.IMRequestCallback
import com.yidianling.im.api.service.IImService
import com.yidianling.tests.api.service.ITestsApiService
import com.yidianling.user.api.bean.UserResponseBean
import com.yidianling.user.api.service.IAppService
import com.yidianling.user.api.service.IUserService

/**
 * author : Zhangwenchao
 * e-mail : zhangwch@yidianling.com
 * time   : 2018/04/25
 */
object TestsIn {

    fun getUserService(): IUserService {
        return ModularServiceManager.provide(IUserService::class.java)
    }

    fun getImService(): IImService {
        return ModularServiceManager.provide(IImService::class.java)
    }

    fun getAppService(): IAppService {
        return ModularServiceManager.provide(IAppService::class.java)
    }

    fun getDynamicService(): IDynamicService {
        return ModularServiceManager.provide(IDynamicService::class.java)
    }

    fun getTestsImpl(): ITestsApiService {
        return ModularServiceManager.provide(ITestsApiService::class.java)
    }
    fun isLogin(): Boolean {
        return ModularServiceManager.provide(IUserService::class.java).isLogin()
    }

    fun getYDLUserInfo(): YdlUserInfo? {
        return ModularServiceManager.getPlatformUserService()?.getUser()
    }

    fun getUserInfo(): UserResponseBean.UserInfo? {
        return ModularServiceManager.provide(IUserService::class.java).getUserInfo()
    }

    fun loginWayIntent(activity: Activity): Intent? {
        return  ModularServiceManager.provide(IUserService::class.java).loginWayIntent(activity)
    }

    fun publishTrendIntent(activity: Activity, url: String, cover: String, title: String): Intent? {
        return getDynamicService()?.publishTrendIntent(activity, url, cover, title)
    }

    fun sendTestResultMessage(uid : String,content : String,title: String?,head : String?,url : String?,id : Int,share_url : String?, callback: IMRequestCallback<Void>) {
        getImService().sendTestResultMessage(uid, content, title, head, url, id, share_url, callback)
    }

    /**
     * 跳转红包
     */
    fun myRedPockIntent(activity: Activity){
        getAppService().myRedPockIntent(activity)
    }

    /**
     * 调用优先使用一键登录，并返回调用时的登录状态，
     * @param isOpenDialog true:一键登录使用弹窗展示 false:一键登录使用全屏模式
     * @return true：已登录，不触发登录跳转，false：未登录，优先一键登录
     * */
    fun loginByOneKeyLogin(context: Context, isOpenDialog: Boolean) :Boolean{
        return getUserService().loginByOneKeyLogin(context,isOpenDialog)
    }
}