package com.yidianling.tests.search

import androidx.recyclerview.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.ydl.ydlcommon.adapter.MyBaseAdapter
import com.yidianling.tests.R
import com.yidianling.tests.list.model.bean.Test
import kotlinx.android.synthetic.main.tests_item_hot_test.view.*

/**
 * HotTestListAdapter
 * Created by zqk on 17-12-5.
 */
class HotTestListAdapter(val hotTestList: MutableList<Test>) : RecyclerView.Adapter<RecyclerView.ViewHolder>() {

    companion object {
        private val TYPE_NORMAL = 0
        private val TYPE_HEADER = 1
    }

    var onItemClickListener: MyBaseAdapter.OnItemClickListener<Test>? = null

    override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) {
        if (holder is NormalViewHolder) {
            holder.tvTestName.text = hotTestList[position - 1].name
        }
    }

    override fun getItemViewType(position: Int): Int {
        return if (position == 0) {
            TYPE_HEADER
        } else {
            TYPE_NORMAL
        }
    }

    override fun getItemCount(): Int = hotTestList.size + 1


    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        return if (viewType == TYPE_NORMAL) {
            val view = LayoutInflater.from(parent!!.context).inflate(R.layout.tests_item_hot_test, parent, false)
            NormalViewHolder(view)
        } else {
            val view = LayoutInflater.from(parent!!.context).inflate(R.layout.tests_item_hot_test_header, parent, false)
            object : RecyclerView.ViewHolder(view) {}
        }
    }

    inner class NormalViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {

        val tvTestName = itemView.tvTestName!!

        init {
            itemView.setOnClickListener {
                if (adapterPosition != RecyclerView.NO_POSITION) {
                    onItemClickListener?.onItemClickListener(itemView, adapterPosition, hotTestList[adapterPosition - 1])
                }
            }
        }
    }
}