package com.yidianling.user.constants

/**
 * Created by xj on 2019/7/1.
 */
class UserBIConstants {
    companion object {
        //消息端来源
        const val APP_ID = "ydl-app-android-user" //这是用户端主包的
        const val OS = "Android" //android系统

        //用户埋点板块
        const val PART_ID_LOGIN_MAIN = "login_main"
        const val PART_ID_LOGIN_MAIN_PREFIX = "login_main|"
        const val YDL_USER_MY_PAGE="ydl_user_my_page|"
        //咨询筛选页
        const val PART_ID_CONSULT_FILTER_PAGE = "consult_filter_page"
        //百度监测 应用启动行为
        const val WELCOME_PAGE = "welcome_page"
        //百度监测 用户注册行为
        const val APP_REGISTER_PAGE = "app_register_page"

        const val POSITION_LOGIN_CLICK = PART_ID_LOGIN_MAIN_PREFIX+"login_click" //登录点击
        const val POSITION_LOGIN_SUCCESS_CLICK = PART_ID_LOGIN_MAIN_PREFIX+"login_success_click" //登录成功点击

        //百度监测 应用启动
        const val POSITION_APP_START_UP_CLICK = "app_start_up_click" //应用启动
        //百度监测 用户注册
        const val POSITION_WX_REGISTER_CLICK = "wx_register_click" //微信第一次登录
        const val POSITION_QQ_REGISTER_CLICK = "qq_register_click" //QQ第一次登录
        const val POSITION_PHONE_REGISTER_CLICK = "phone_register_click" //手机号密码第一次登录
        const val POSITION_ALIYUN_REGISTER_CLICK = "aliyun_register_click" //阿里云第一次一键登录
        const val POSITION_CODE_REGISTER_CLICK = "code_register_click" //短信第一次登录
        const val POSITION_FIRST_LOAD_AND_OPEN_CLICK = "activation_click" //第一次安装并且第一打开

        //随便逛逛点击
        const val POSITION_LOOK_AROUND_CLICK = "look_around_click"

        //登录主页浏览事件（包含随便逛逛）
        const val POSITION_LOGIN_ONE_PAGE_VISIT = "login_main_one_page_visit"

        //登录主页浏览事件（不包含随便逛逛）
        const val POSITION_LOGIN_TWO_PAGE_VISIT = "login_main_two_page_visit"

        //隐私授权页事件埋点
        const val PRIVACY_AUTHORIZATION_CLICK =
            "privacy_authorization_page|privacy_authorization_click"

        //手机注册页 手机号一键登录页右上角点击跳过
        const val USER_REGISTER_PAGE_SKIP_CLICK = "user_register_page|skip_click"

        //隐私授权二次确认弹窗
        const val PRIVACY_AUTHORIZATION_TWO_CLICK =
            "privacy_authorization_page|privacy_authorization_two_click"

        //百度监测 用户信息收集页面
        const val COLLECT_USER_INFO_PAGE = "collect_user_info_page"

        const val COLLECT_USER_INFO_PAGE_VISIT =
            "collect_user_info_page_visit" //百度监测 用户信息收集页面--页面浏览事件
        const val COLLECT_USER_INFO_SEX_MAN_CLICK =
            "collect_user_info_sex_man_click" // （sign1存储状态（1代表选中，2代表取消），String） //百度监测 用户信息收集页面--性别男按钮点击
        const val COLLECT_USER_INFO_SEX_FEMALE_CLICK =
            "collect_user_info_sex_female_click" // （sign1存储状态（1代表选中，2代表取消），String） //百度监测 用户信息收集页面--性别女按钮点击
        const val COLLECT_USER_INFO_NEXT_CLICK =
            "collect_user_info_next_click" //百度监测 用户信息收集页面--下一步点击
        const val COLLECT_USER_INFO_EXIT_CLICK =
            "collect_user_info_exit_click" //百度监测 用户信息收集页面--退出点击

        //百度监测 收集感兴趣话题页
        const val COLLECT_TOPIC_PAGE = "collect_topic_page"
        const val COLLECT_TOPIC_PAGE_VISIT = "collect_topic_page_visit" //百度监测 页面浏览事件
        const val COLLECT_TOPIC_CLICK = "collect_topic_click" //百度监测 话题点击 ( sign1存储话题，例如：情绪压力)
        const val COLLECT_TOPIC_SUBMIT_CLICK = "collect_topic_submit_click" //百度监测 提交点击
        const val COLLECT_TOPIC_INFO_EXIT_CLICK = "collect_topic_info_exit_click" //百度监测 退出点击

        /**
         * action type
         * 行为数据埋点，sign1字段 是对同一key下多种不同行为的描述
         */
        const val ACTION_TYPE_CODE_LOGIN: String = "code_login" //验证码登录
        const val ACTION_TYPE_RESET_PWD: String = "reset_pwd" //重置密码登录
        const val ACTION_TYPE_PWD_LOGIN: String = "pwd_login" //手机号密码登录
        const val ACTION_TYPE_DIRECT_LOGIN: String = "direct_login" //一键本机号码校验登录
        const val ACTION_TYPE_ONE_KEY_CLICK: String = "one_click_login" //一键登录
        const val ACTION_TYPE_QQ_THIRD_LOGIN: String = "qq_login" //QQ登录
        const val ACTION_TYPE_WX_THIRD_LOGIN: String = "wx_login" //WX登录
    }
class UserMyPageEvent{
    companion object {
        const val YDL_USER_MY_PAGE_VISIT=YDL_USER_MY_PAGE+"YDL_USER_MY_PAGE_VISIT"
        const val YDL_USER_MY_PAGE_STAY_VISIT=YDL_USER_MY_PAGE+"YDL_USER_MY_PAGE_STAY_VISIT"
        const val YDL_USER_MY_TOP_TYPE_CLICK= YDL_USER_MY_PAGE+"ydl_user_my_top_type_click"
        const val YDL_USER_MY_MIDDLE_TYPE_CLICK= YDL_USER_MY_PAGE+"ydl_user_my_middle_type_click"
        //app我的页_会员中心区域点击
        const val YDL_USER_MY_MEMBER_CENTRE_CLICK = YDL_USER_MY_PAGE + "member_centre_click"
        const val YDL_USER_MY_BOTTOM_TYPE_CLICK= YDL_USER_MY_PAGE+"ydl_user_my_bottom_type_click"
    }
}
    //====================壹点灵用户版首页（ydl_user_main_page）====================
    class UserMainEvent {
        companion object {

            private const val YDL_USER_MAIN_PAGE: String = "ydl_user_main_page|"//壹点灵用户版首页    partId

            const val YDL_USER_SEARCH_CLICK: String = YDL_USER_MAIN_PAGE + "ydl_user_search_click"//搜索栏
            const val YDL_USER_TELEPHONE_CUSTOMER_SERVICE_CLICK: String = YDL_USER_MAIN_PAGE + "ydl_user_telephone_customer_service_click"//电话客服
            const val YDL_USER_BANNER_CLICK: String = YDL_USER_MAIN_PAGE + "ydl_user_banner_click"//banner
            const val YDL_USER_NOTICE_CLICK: String = YDL_USER_MAIN_PAGE + "ydl_user_notice_click"//公告
            const val YDL_USER_CONSULT_CLASSIFICATION_CLICK: String = YDL_USER_MAIN_PAGE + "ydl_user_consult_classification_click"//首页咨询分类
            const val YDL_USER_CONSULT_CLICK: String = YDL_USER_MAIN_PAGE + "ydl_user_consult_click"//四个大按钮 心理咨询点击人数
            const val YDL_USER_TALK_IN_TIME_CLICK: String = YDL_USER_MAIN_PAGE + "ydl_user_talk_in_time_click"//四个大按钮 即时倾诉点击人数
            const val YDL_USER_PSYCHOLOGICAL_CLASSROOM_CLICK: String = YDL_USER_MAIN_PAGE + "ydl_user_psychological_classroom_click"//四个大按钮 心理课堂点击人数
            const val YDL_USER_PSYCHOLOGICAL_TEST_CLICK: String = YDL_USER_MAIN_PAGE + "ydl_user_psychological_test_click"//四个大按钮 心理测试点击人数
            const val YDL_USER_CONSULT_MORE_CLICK: String = YDL_USER_MAIN_PAGE + "ydl_user_consult_more_click"//咨询解惑更多
            const val YDL_USER_CONSULT_TYPE_CLICK: String = YDL_USER_MAIN_PAGE + "ydl_user_consult_type_click"//咨询解惑分类标签
            const val YDL_USER_EXPERT_INTRODUCTION_CLICK: String = YDL_USER_MAIN_PAGE + "ydl_user_expert_introduction_click"//咨询师介绍模块
            const val YDL_USER_PRIVATE_CHAT_CLICK: String = YDL_USER_MAIN_PAGE + "ydl_user_private_chat_click"//咨询师私聊按钮
            const val YDL_USER_LISTEN_MORE_CLICK: String = YDL_USER_MAIN_PAGE + "ydl_user_listen_more_click"//倾诉排解更多
            const val YDL_USER_LISTEN_TYPE_CLICK: String = YDL_USER_MAIN_PAGE + "ydl_user_listen_type_click"//倾诉排解分类标签
            const val YDL_USER_LISTENER_INTRODUCTION_CLICK: String = YDL_USER_MAIN_PAGE + "ydl_user_listener_introduction_click "//倾诉师介绍模块
            const val YDL_USER_COURSE_MORE_CLICK: String = YDL_USER_MAIN_PAGE + "ydl_user_course_more_click"//课程成长更多
            const val YDL_USER_COURSE_CLICK: String = YDL_USER_MAIN_PAGE + "ydl_user_course_click"//课程标题图区域
            const val YDL_USER_ASK_MORE_CLICK: String = YDL_USER_MAIN_PAGE + "ydl_user_ask_more_click"//解忧问答更多
            const val YDL_USER_ASK_COMMENT_CLICK: String = YDL_USER_MAIN_PAGE + "ydl_user_ask_comment_click"//问答评论区域
            const val YDL_USER_HEART_RADIO_MORE_CLICK: String = YDL_USER_MAIN_PAGE + "ydl_user_heart_radio_more_click"//心灵电台更多
            const val YDL_USER_RADIO_CLICK: String = YDL_USER_MAIN_PAGE + "ydl_user_radio_click "//区域内四个标题
            const val YDL_USER_RADIO_PLAY_CLICK: String = YDL_USER_MAIN_PAGE + "ydl_user_radio_play_click"//心灵电台play按钮点击
            const val YDL_USER_ARTICLE_MORE_CLICK: String = YDL_USER_MAIN_PAGE + "ydl_user_article_more_click"//文章阅读更多
            const val YDL_USER_ARTICLE_CLICK: String = YDL_USER_MAIN_PAGE + "ydl_user_article_click"//文章标题图区域
            const val YDL_USER_MAIN_PAGE_VISIT: String = YDL_USER_MAIN_PAGE + "ydl_user_main_page_visit"//首页浏览事件
        }
    }


}