package com.yidianling.user.http.request

/**
 * author : Zhangwenchao
 * e-mail : zhangwch@yidianling.com
 * time   : 2018/02/02
 */
data class LoginParam(val country_code: String,
                      val userName: String,//手机号
                      val passwd: String?,//密码(md5后的密码)
                      val login_type: Int = 1, // 登录方式（密码，短信验证码）
                      val vcode: String?) {  // 短信验证码)

    private constructor(builder: Builder) : this(builder.country_code,
            builder.userName,
            builder.passwd,
            builder.login_type,
            builder.vcode)

    companion object {
        fun build(init: Builder.() -> Unit) = Builder(init).build()
    }

    class Builder private constructor() {

        constructor(init: Builder.() -> Unit) : this() {
            init()
        }

        lateinit var country_code: String
        lateinit var userName: String
        var passwd: String? = null
        var login_type: Int = 0
        var vcode: String? = null

        fun country_code(init: Builder.() -> String) = apply { country_code = init() }
        fun userName(init: Builder.() -> String) = apply { userName = init() }
        fun passwd(init: Builder.() -> String) = apply { passwd = init() }
        fun login_type(init: Builder.() -> Int) = apply { login_type = init() }
        fun vcode(init: Builder.() -> String) = apply { vcode = init() }

        fun build() = LoginParam(this)
    }


}