package com.yidianling.user.mine;

import android.app.Activity;
import android.view.View;
import android.view.ViewGroup;

import com.ydl.ydlcommon.adapter.CommonAdapter;
import com.yidianling.user.bean.FundData;


/**
 * Created by softrice on 15/12/2.
 */
public class AccountHistoryListAdapter extends CommonAdapter<FundData.Fund> {

    Activity context;
    private String available = "0.00";

    public AccountHistoryListAdapter(Activity context) {
        this.context = context;
    }


    public void setAvailable(String available) {
        this.available = available;
        notifyDataSetChanged();
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        if (convertView == null) {
            convertView = new AccountHistoryListItemView(context);
        }
        if (position == 0) {
//            if (mDataList != null && mDataList.size() > 0) {
//                ((AccountHistoryListItemView) convertView).setHeadData(mDataList.get(position).available);
//            } else {
//                ((AccountHistoryListItemView) convertView).setHeadData("0.00");
//            }

            ((AccountHistoryListItemView) convertView).setHeadData(available);
        } else {
            ((AccountHistoryListItemView) convertView).setData(mDataList.get(position - 1));
        }

        if (position == mDataList.size()) {
            ((AccountHistoryListItemView) convertView).setIsLast(true);
        } else {
            ((AccountHistoryListItemView) convertView).setIsLast(false);
        }


        return convertView;
    }

    @Override
    public int getCount() {
        return mDataList == null ? 1 : mDataList.size() + 1;
    }

}
