package com.yidianling.user.mine

import android.annotation.SuppressLint
import android.view.Gravity
import com.ydl.ydlcommon.base.BaseActivity
import com.ydl.ydlcommon.bean.StatusBarOptions
import com.ydl.ydlcommon.view.dialog.CommonDialog
import com.yidianling.common.tools.ToastUtil
import com.yidianling.user.R
import com.yidianling.user.event.UnRegisterEvent
import com.yidianling.user.http.UserHttpImpl
import com.yidianling.user.http.request.UserForbidLoginParam
import de.greenrobot.event.EventBus
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.schedulers.Schedulers
import kotlinx.android.synthetic.main.activity_account_un_register.*

/**
 * 账号注销协议页面
 */
class AccountUnRegisterActivity : BaseActivity() {

    override fun layoutResId(): Int {
        return R.layout.activity_account_un_register
    }

    override fun getStatusViewOptions(): StatusBarOptions {
        return StatusBarOptions(isAddStatusView = true, statusBarDarkMode = true)
    }

    override fun initDataAndEvent() {
        //无网络 读取本地文件
        web_view.loadUrl("file:///android_asset/html/accountUnregister.html")
        tv_unregister.setOnClickListener {

            CommonDialog(this)
                .setTitle("确定注销账号？")
                .setTitle_color(R.color.platform_color_242424)
                .setMessage(
                    """
                    为了保护您的账户、财产安全，在您提交注销前，需同时满足以下条件：
                    1.账号财产已清零，即账户余额为0；
                    2.不存在交易中的订单，即咨询订单状态均为交易成功或交易关闭；
                    3.无退款中的订单。
                    """.trimIndent()
                )
                .setMessageTextGravity(Gravity.LEFT)
                .setMessageColor(R.color.platform_color_666666)
                .setLeftOnclick("下次再说") { }
                .setLeftButton_color(R.color.platform_color_666666)
                .setRightClick("确定") {
                    userForbidLogin()
                }
                .setRightButton_color(R.color.white)
                .setRightButtonBackgroundColor(R.color.baby_blue)
                .show()
        }
    }

    @SuppressLint("CheckResult")
    private fun userForbidLogin() {
        val param = UserForbidLoginParam()
        param.userPort = 1;
        UserHttpImpl.getInstance().accountLogOff(param)
            .subscribeOn(Schedulers.io())
            .observeOn(AndroidSchedulers.mainThread())
            .subscribe {
                if (it.code == "200" && !isFinishing && it.data) {
                    ToastUtil.toastLong(this@AccountUnRegisterActivity,"账号已注销")
                    EventBus.getDefault().post(UnRegisterEvent())
                    finish()
                } else {
                    ToastUtil.toastLong(this@AccountUnRegisterActivity,it.msg)
                }

            }
    }
}