package com.yidianling.user.mine

import android.os.Bundle
import android.view.Gravity
import android.view.View
import android.widget.TextView
import androidx.fragment.app.DialogFragment
import com.ydl.ydlcommon.base.BaseDialogFragment
import com.yidianling.user.R

/**
 * 修改头像dialog
 */
class AvaterDialog : BaseDialogFragment() {
    override fun getLayoutResourceId(): Int = R.layout.dialog_album_photo
    override fun setGravity(): Int = Gravity.BOTTOM

    lateinit var listener: (Int, DialogFragment) -> Unit

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        val tv_album = view.findViewById<TextView>(R.id.tv_album)
        tv_album.setOnClickListener {
            listener.invoke(0, this)
        }
        val tv_photo = view.findViewById<TextView>(R.id.tv_photo)
        tv_photo.setOnClickListener {
            listener.invoke(1, this)
        }
        val tv_cancel = view.findViewById<TextView>(R.id.tv_cancel)
        tv_cancel.setOnClickListener {
            listener.invoke(2, this)
        }
    }
}