package com.yidianling.user.mine

import android.annotation.SuppressLint
import android.app.Activity
import android.content.Intent
import android.text.TextUtils
import com.yidianling.user.mine.bean.AccountBean
import com.ydl.ydlcommon.base.BaseActivity
import com.ydl.ydlcommon.data.http.RxUtils
import com.ydl.ydlcommon.data.http.ThrowableConsumer
import com.ydl.ydlcommon.utils.TransferCacheUtils
import com.yidianling.common.tools.ToastUtil
import com.yidianling.user.R
import com.yidianling.user.mine.bean.EditAccountCmd
import com.yidianling.user.mine.data.AppDataManager
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.functions.Consumer
import kotlinx.android.synthetic.main.user_mine_activity_edit_account.*

/**
 * 编辑提现帐号
 */
class EditAccountActivity : BaseActivity() {
    private var accountBean: AccountBean? = null

    companion object {
        fun startForResult(activity: Activity, bean: AccountBean, code: Int) {
            if (bean == null) {
                ToastUtil.toastShort("帐号信息错误")
                return
            }
            var intent = Intent(activity, EditAccountActivity::class.java)
            TransferCacheUtils.putTransferData(ChooseAccountActivity.INTENT_DATA, bean)
            activity.startActivityForResult(intent, code)
        }
    }

    override fun layoutResId(): Int {
        return R.layout.user_mine_activity_edit_account
    }

    override fun initDataAndEvent() {
        accountBean = TransferCacheUtils.getTransferData(ChooseAccountActivity.INTENT_DATA) as AccountBean?
        TransferCacheUtils.removeTransferData(ChooseAccountActivity.INTENT_DATA)
        //编辑账户时账户信息不显示在界面上
        et_account.setText("")
        et_name.setText("")

        btn_ensure.setOnClickListener({ eidtAccount() })
    }

    /**
     * 编辑支付宝帐号
     */
    @SuppressLint("CheckResult")
    private fun eidtAccount() {
        var account = et_account.text.trim().toString()
        if (TextUtils.isEmpty(account)) {
            ToastUtil.toastShort("支付宝帐号不能为空")
            return
        }
        var name = et_name.text.trim().toString()
        if (TextUtils.isEmpty(name)) {
            ToastUtil.toastShort("姓名不能为空")
            return
        }

        var param = EditAccountCmd(accountBean!!.id, name, "1", account)
        showProgressDialog("")
        AppDataManager.getHttp().editAccount(param)
                .compose(RxUtils.resultData())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(Consumer {
                    ToastUtil.toastShort("编辑帐号成功")
                    accountBean!!.account = it.account
                    accountBean!!.cashName = it.cashName
                    var intent = Intent()
                    TransferCacheUtils.putTransferData(ChooseAccountActivity.INTENT_DATA, accountBean)
                    setResult(Activity.RESULT_OK, intent)
                    finish()
                }, object : ThrowableConsumer() {
                    override fun accept(msg: String) {
                        dismissProgressDialog()
                        ToastUtil.toastShort(msg)
                    }
                })
    }


}
