package com.yidianling.user.mine;

import static com.yidianling.user.mine.ModifyInfoActivityKt.NICKNAME;
import static com.yidianling.user.mine.ModifyInfoActivityKt.INTRODUCTION;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.text.TextUtils;
import android.view.View;
import android.widget.DatePicker;
import android.widget.ImageView;
import android.widget.RelativeLayout;

import com.alibaba.android.arouter.facade.annotation.Route;
import com.bumptech.glide.Glide;
import com.ydl.ydl_image.module.GlideApp;
import com.ydl.ydl_image.transform.GlideCircleTransform;
import com.ydl.ydlcommon.base.BaseActivity;
import com.ydl.ydlcommon.bean.StatusBarOptions;
import com.ydl.ydlcommon.data.http.ThrowableConsumer;
import com.ydl.ydlcommon.utils.PopUtils;
import com.ydl.ydlcommon.utils.remind.ToastHelper;
import com.ydl.ydlcommon.view.JumpTextView;
import com.ydl.ydlcommon.view.ListNoCancelDialog;
import com.ydl.ydlcommon.view.TitleBar;
import com.ydl.ydlcommon.view.dialog.ListDialog;
import com.yidianling.common.tools.ToastUtil;
import com.yidianling.user.R;
import com.yidianling.user.UserHelper;
import com.yidianling.user.api.bean.UserResponseBean;
import com.yidianling.user.http.UserHttp;
import com.yidianling.user.http.UserHttpImpl;
import com.yidianling.user.http.request.UserInfoParam;

import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;

import de.greenrobot.event.EventBus;
import io.reactivex.android.schedulers.AndroidSchedulers;


/**
 * 个人资料
 * Created by softrice on 15/12/2.
 */
@Route(path = "/user/personInfo")
public class PersonalInfoActivity extends BaseActivity implements View.OnClickListener {

    private final int AVATAR = 0x0; // 头像
    private final int NICK = 0x1; // 昵称

    UserResponseBean.UserInfo userInfoData;

    TitleBar tb_title;
    ImageView persion_head_iv;
    ImageView person_head_hint_iv;
    RelativeLayout persion_head_rel;
    JumpTextView jtv_nick;
    JumpTextView jtv_sex;
    JumpTextView jtv_birthday;
    JumpTextView jtv_marriage_state;
    JumpTextView jtv_career;
    JumpTextView jtv_jianjie;

    private final DatePickerDialogFragment datePickerDialogFragment = new DatePickerDialogFragment();

    @NotNull
    @Override
    public StatusBarOptions getStatusViewOptions() {
        return new StatusBarOptions(true,true);
    }
    @Override
    protected int layoutResId() {
        return R.layout.user_mine_activity_personal_info;
    }

    @Override
    protected void initDataAndEvent() {
        tb_title = findViewById(R.id.tb_title);
        persion_head_iv = findViewById(R.id.persion_head_iv);
        person_head_hint_iv = findViewById(R.id.person_head_hint_iv);
        persion_head_rel = findViewById(R.id.persion_head_rel);
        jtv_nick = findViewById(R.id.jtv_nick);
        jtv_sex = findViewById(R.id.jtv_sex);
        jtv_birthday = findViewById(R.id.jtv_birthday);
        jtv_marriage_state = findViewById(R.id.jtv_marriage_state);
        jtv_career = findViewById(R.id.jtv_career);
        jtv_jianjie = findViewById(R.id.jtv_jianjie);
        userInfoData = UserHelper.INSTANCE.getUserInfo().getUserInfo();

        jtv_nick.setOnClickListener(this);
        jtv_sex.setOnClickListener(this);
        jtv_birthday.setOnClickListener(this);
        jtv_career.setOnClickListener(this);
        jtv_marriage_state.setOnClickListener(this);
        jtv_jianjie.setOnClickListener(this);
        persion_head_rel.setOnClickListener(this);
        init();
    }


    void init() {
        tb_title.setRightImageListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                PopUtils.showMoreItem(PersonalInfoActivity.this,
                        tb_title.getRootView(),
                        0,
                        0);
            }
        });
        tb_title.setRightImageIfShouldSee();

        setData();
//        mChooseSexDialog.setListener(this);
        datePickerDialogFragment.setDateChangedListener(new DatePicker.OnDateChangedListener() {
            @Override
            public void onDateChanged(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
                monthOfYear++;
                updateInfo("birthday", year + "-" + monthOfYear + "-" + dayOfMonth);

            }
        });
    }

    private void setData() {
        if (userInfoData == null) return;

        String head_url = UserHelper.INSTANCE.getUserInfo().getUserInfo().getHead();
        GlideApp.with(PersonalInfoActivity.this)
                .load(head_url)
                .override(100, 100)
                .transform(new GlideCircleTransform(PersonalInfoActivity.this))
                .error(R.drawable.platform_head_place_hold_pic)
                .into(persion_head_iv);
        String nick_name = UserHelper.INSTANCE.getUserInfo().getUserInfo().getNick_name();
        if (!TextUtils.isEmpty(nick_name))
            jtv_nick.setRightText(nick_name);
        else
            jtv_nick.setRightText("");

        if (userInfoData.getGender() == 1)
            jtv_sex.setRightText("男");
        else
            jtv_sex.setRightText("女");

        setCareer(userInfoData.getProfession());
        setMarriage(userInfoData.getMarriage());

        if (userInfoData.getProfession() == 0) {
            jtv_career.setRightText("请选择");
        }

        jtv_birthday.setRightText(userInfoData.getBirthday());
    }

    @Override
    public void onClick(View v) {
        int id = v.getId();
        if (id == R.id.persion_head_rel) { // 头像
            startActivityForResult(new Intent(this, ModifyAvatarActivity.class), AVATAR);
        } else if (id == R.id.jtv_nick) {//昵称
            Intent intent = new Intent(this, ModifyInfoActivity.class);
            intent.putExtra("from", NICKNAME);
            startActivityForResult(intent, NICK);
        } else if (id == R.id.jtv_sex) {//性别
            List<String> sexs = new ArrayList<String>();
            sexs.add("男");
            sexs.add("女");
            ListNoCancelDialog.Builder builder1 = new ListNoCancelDialog.Builder(PersonalInfoActivity.this, sexs, 0);
            builder1.setOnItemClickLister(new ListNoCancelDialog.Builder.OnItemClickLister() {
                @Override
                public void onItemClick(Dialog dialog, View view, int position) {
                    switch (position) {
                        case 0:
                            if (userInfoData != null && userInfoData.getGender() == 1) {

                            } else {
                                updateInfo("gender", "1");
                            }
                            dialog.dismiss();
                            break;
                        case 1:
                            if (userInfoData != null && userInfoData.getGender() == 2) {

                            } else {
                                updateInfo("gender", "2");
                            }
                            dialog.dismiss();
                            break;
                    }
                }

                @Override
                public void onItemLongClick(Dialog dialog, View view, int position) {

                }
            });
            builder1.create().show();
        } else if (id == R.id.jtv_birthday) {//生日
            datePickerDialogFragment.show(getFragmentManager(), datePickerDialogFragment.getClass().getName());
        } else if (id == R.id.jtv_career) {//职业
            List<String> jobs = new ArrayList<String>();
            jobs.add("学生党");
            jobs.add("上班族");
            jobs.add("全职父母");
            jobs.add("商人");
            ListDialog.Builder builderj = new ListDialog.Builder(PersonalInfoActivity.this, jobs, 0);
            builderj.SetLastStr("取消");
            builderj.SetLastButton("取消", new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            });
            builderj.SetOnItemClickLister(new ListDialog.Builder.OnItemClickLister() {
                @Override
                public void onItemClick(Dialog dialog, View view, int position) {
                    switch (position) {
                        case 0:
                        case 1:
                        case 2:
                        case 3:
                            updateInfo("profession", String.valueOf(position + 1));
                            dialog.dismiss();
                            break;
                    }
                }

                @Override
                public void onItemLongClick(Dialog dialog, View view, int position) {

                }
            });
            builderj.create().show();
        } else if (id == R.id.jtv_marriage_state) {//婚姻状态
            List<String> marriages = new ArrayList<String>();
            marriages.add("单身");
            marriages.add("恋爱中");
            marriages.add("已婚");
            ListDialog.Builder builderm = new ListDialog.Builder(PersonalInfoActivity.this, marriages, 0);
            builderm.SetLastStr("取消");
            builderm.SetLastButton("取消", new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            });
            builderm.SetOnItemClickLister(new ListDialog.Builder.OnItemClickLister() {
                @Override
                public void onItemClick(Dialog dialog, View view, int position) {
                    switch (position) {
                        case 0:
                        case 1:
                        case 2:
                            updateInfo("marriage", String.valueOf(position + 1));
                            dialog.dismiss();
                            break;
                    }
                }

                @Override
                public void onItemLongClick(Dialog dialog, View view, int position) {

                }
            });
            builderm.create().show();
        } else if (id == R.id.jtv_jianjie) {//个人简介
            Intent intent = new Intent(this, ModifyInfoActivity.class);
            intent.putExtra("from", INTRODUCTION);
            startActivity(intent);
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == RESULT_OK) {
            switch (requestCode) {
                case AVATAR: {
                    Glide.with(PersonalInfoActivity.this)
                            .load(userInfoData.getHead())
                            .override(100, 100)
                            .transform(new GlideCircleTransform(PersonalInfoActivity.this))
                            .error(R.drawable.platform_head_place_hold_pic)
                            .into(persion_head_iv);
                }
                case NICK: {
                    jtv_nick.setRightText(userInfoData.getNick_name());
                    break;
                }
            }
        }
    }

    @SuppressLint("CheckResult")
    void updateInfo(final String changType, final String value) {
        showProgressDialog("保存中...");

        UserHttp userHttp = UserHttpImpl.Companion.getInstance();

        userHttp.setUserInfo(new UserInfoParam(changType, value))
                .compose(com.ydl.ydlcommon.data.http.RxUtils.resultData())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(o -> {
                    jtv_sex.postDelayed(() -> {
                        dismissProgressDialog();
                        ToastUtil.toastShort("保存成功");
                    }, 500);
                    UserResponseBean.UserInfo userInfo = UserHelper.INSTANCE.getUserInfo().getUserInfo();
                    switch (changType) {
                        case "gender":
                            switch (value) {
                                case "1":
                                    jtv_sex.setRightText("男");
                                    userInfo.setGender(1);
                                    break;
                                case "2":
                                    jtv_sex.setRightText("女");
                                    userInfo.setGender(2);
                                    break;
                            }
                            break;
                        case "profession":
                            setCareer(Integer.valueOf(value));
                            userInfo.setProfession(Integer.valueOf(value));
                            break;
                        case "marriage":
                            setMarriage(Integer.valueOf(value));
                            userInfo.setMarriage(Integer.valueOf(value));
                            break;
                        case "birthday":
                            jtv_birthday.setRightText(value);
                            userInfo.setBirthday(value);
                            break;
                        case "homeBg":
                            //封面背景
                            userInfo.setHome_bg(value);
                            break;
//                        case "home_desc": // 简介
//                            userInfo.setDescription(value);
//                            break;
                    }
                    EventBus.getDefault().post(userInfoData);
                }, new ThrowableConsumer() {
                    @Override
                    public void accept(@NotNull String msg) {
                        ToastHelper.Companion.show(msg);
                    }
                });

    }

    private void setCareer(int select) {
        switch (select) {
            case 0:
                jtv_career.setRightText("请选择");
                break;
            case 1:
                jtv_career.setRightText("学生党");
                break;
            case 2:
                jtv_career.setRightText("上班族");
                break;
            case 3:
                jtv_career.setRightText("全职父母");
                break;
            case 4:
                jtv_career.setRightText("商人");
                break;
        }
    }

    private void setMarriage(int select) {
        switch (select) {
            case 0:
                jtv_marriage_state.setRightText("请选择");
                break;
            case 1:
                jtv_marriage_state.setRightText("单身");
                break;
            case 2:
                jtv_marriage_state.setRightText("恋爱中");
                break;
            case 3:
                jtv_marriage_state.setRightText("已婚");
                break;

        }
    }

}
