package com.yidianling.user.mine;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.text.TextUtils;
import android.widget.EditText;

import com.ydl.ydlcommon.base.BaseActivity;
import com.ydl.ydlcommon.bean.StatusBarOptions;
import com.ydl.ydlcommon.data.http.RxUtils;
import com.ydl.ydlcommon.data.http.ThrowableConsumer;
import com.ydl.ydlcommon.utils.remind.ToastHelper;
import com.ydl.ydlcommon.view.RoundCornerButton;
import com.yidianling.user.R;
import com.yidianling.user.http.UserHttp;
import com.yidianling.user.http.UserHttpImpl;
import com.yidianling.user.http.request.CheckPwd;

import org.jetbrains.annotations.NotNull;

import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Consumer;

/**
 * 修改绑定手机的密码验证
 */
public class PwdCheckActivity extends BaseActivity {

    EditText check_password;
    RoundCornerButton change_next;

    @NotNull
    @Override
    public StatusBarOptions getStatusViewOptions() {
        return new StatusBarOptions(true,true);
    }

    @Override
    protected int layoutResId() {
        return R.layout.user_mine_activity_pwdcheck;
    }

    @SuppressLint("CheckResult")
    @Override
    protected void initDataAndEvent() {
        check_password = findViewById(R.id.check_password);
        change_next = findViewById(R.id.change_next);

        change_next.setOnClickListener(v -> {
            String pwd = check_password.getText().toString();
            if (TextUtils.isEmpty(pwd)) {
                ToastHelper.Companion.show("密码不能为空");
                return;
            }
            UserHttp userHttp = UserHttpImpl.Companion.getInstance();
            userHttp.checkPwd(new CheckPwd(pwd))
                    .compose(RxUtils.resultData())
                    .observeOn(AndroidSchedulers.mainThread())
                    .subscribe(new Consumer<Object>() {
                        @Override
                        public void accept(Object o) throws Exception {
                            startActivity(new Intent(PwdCheckActivity.this, PhoneChangeActivity.class));
                        }
                    }, new ThrowableConsumer() {
                        @Override
                        public void accept(@NotNull String msg) {
                            ToastHelper.Companion.show(msg);
                        }
                    });
        });
    }



}
