package com.yidianling.user.mine

import android.annotation.SuppressLint
import android.app.Activity
import android.content.Intent
import com.ydl.ydlcommon.base.BaseActivity
import com.ydl.ydlcommon.bean.StatusBarOptions
import com.ydl.ydlcommon.utils.ActivityManager
import com.yidianling.user.R
import kotlinx.android.synthetic.main.user_mine_activity_with_draw_success.*

class WithDrawSuccessActivity : BaseActivity() {

    override fun getStatusViewOptions(): StatusBarOptions {
        return StatusBarOptions(true, true)
    }

    companion object {
        var INTENT_REMARK = "intent_remark"
        fun start(activity: Activity, remark: String) {
            var intent = Intent(activity, WithDrawSuccessActivity::class.java)
            intent.putExtra(INTENT_REMARK, remark)
            activity.startActivity(intent)
        }
    }


    override fun layoutResId(): Int {
        return R.layout.user_mine_activity_with_draw_success
    }

    @SuppressLint("SetTextI18n")
    override fun initDataAndEvent() {
        ActivityManager.finishActivity(WithDrawActivity::class.java)
        val remark = intent.getStringExtra(INTENT_REMARK)
        tv_info.text = "您的提现申请已提交\n$remark\n请关注您的帐号资金变动情况，谢谢"
        btn_ensure.setOnClickListener {
            finish()
        }
    }
}
