package com.yidianling.user.mine.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.yidianling.user.R;
import com.yidianling.user.mine.bean.AccountBean;
import com.ydl.ydl_image.module.GlideApp;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * Created by jiucheng on 2018/7/13.
 * 功能：
 */

public class AccountListAdapter extends BaseAdapter {
    private Context context;
    private List<AccountBean> list;
    private OnChooseItemListener listerner;

    public AccountListAdapter(Context context, OnChooseItemListener listerner) {
        this.context = context;
        this.listerner = listerner;
    }

    public void setList(List<AccountBean> list) {
        if (list == null) {
            list = new ArrayList<>();
        }
        this.list = list;
        notifyDataSetChanged();
    }

    public void deleteAccount(AccountBean bean) {
        if (bean != null) {
            if (list.contains(bean)) {
                list.remove(bean);
                notifyDataSetChanged();
            }
        }
    }

    @Override
    public int getCount() {
        return list == null ? 0 : list.size();
    }

    @Override
    public Object getItem(int position) {
        return null;
    }

    public List<AccountBean> getData() {
        if (list != null) {
            return list;
        } else {
            return new ArrayList<>();
        }
    }

    @Override
    public long getItemId(int position) {
        return 0;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        AccountBean bean = list.get(position);
        if (convertView == null) {
            convertView = View.inflate(context, R.layout.user_mine_item_account_info, null);
            holder = new ViewHolder();
            holder.accountName = convertView.findViewById(R.id.tv_account);
            holder.ll_content = convertView.findViewById(R.id.ll_content);
            holder.info = convertView.findViewById(R.id.tv_info);
            holder.choose = convertView.findViewById(R.id.iv_choose);
            holder.icon = convertView.findViewById(R.id.iv_icon);
            holder.tv_remark = convertView.findViewById(R.id.tv_remark);
            convertView.setTag(holder);
        } else {
            holder = (ViewHolder) convertView.getTag();
        }

        holder.choose.setVisibility(bean.isDefault() == 1 ? View.VISIBLE : View.GONE);
        if (!TextUtils.isEmpty(bean.getBankIcon())) {
            GlideApp.with(context)
                    .load(bean.getBankIcon())
                    .into(holder.icon);
        }
//        else {
//            if (bean.getType() == 1) {
//                GlideApp.with(context)
//                        .load(R.mipmap.ico_alipay)
//                        .into(holder.icon);
//            }
//        }

        if (bean.getType() == 1) {
            holder.accountName.setText("支付宝");
        } else if (bean.getType() == 2) {
            holder.accountName.setText("微信");
        } else if (bean.getType() == 3) {
            holder.accountName.setText(bean.getBankName());
        }
        holder.info.setText(bean.getAccount());
        holder.tv_remark.setText(bean.getRemark());
        return convertView;
    }

    public void checkChoose(int position) {
        if (list.get(position).isDefault() == 1) {
            if (listerner != null) {
                listerner.onChooseItemClick(getData());
            }
        } else {
            for (int i = 0; i < list.size(); i++) {
                if (i == position) {
                    list.get(position).setDefault(1);
                } else {
                    list.get(i).setDefault(0);
                }
            }
            notifyDataSetChanged();
            io.reactivex.Observable.timer(300, TimeUnit.MILLISECONDS)
                    .subscribe(aLong -> {
                        if (listerner != null) {
                            listerner.onChooseItemClick(getData());
                        }
                    });
        }
    }

    class ViewHolder {
        public ImageView icon;
        public ImageView choose;
        public TextView accountName;
        public TextView tv_remark;
        public TextView info;
        public LinearLayout ll_content;
    }


    public interface OnChooseItemListener {
        void onChooseItemClick(List<AccountBean> list);
    }
}
