package com.yidianling.user.mine.http

import com.ydl.ydlcommon.bean.MustUP
import com.ydl.ydlcommon.data.http.BaseAPIResponse
import com.ydl.ydlcommon.data.http.BaseCommand
import com.ydl.ydlcommon.data.http.BaseResponse
import com.yidianling.im.message.param.MsgListParam
import com.yidianling.user.api.bean.UserResponseBean
import com.yidianling.user.bean.EffectivityBean
import com.yidianling.user.bean.EvaluateOrderBean
import com.yidianling.user.bean.FundData
import com.yidianling.user.bean.Recharge
import com.yidianling.user.mine.APPWillUpParam
import com.yidianling.user.mine.FeedBackParam
import com.yidianling.user.mine.FundListParam
import com.yidianling.user.mine.RechargeParam
import com.yidianling.user.mine.bean.AccountBean
import com.yidianling.user.mine.bean.BalanceBean
import com.yidianling.user.mine.bean.CouponNumBean
import com.yidianling.user.mine.bean.FeedBackDetailBean
import io.reactivex.Observable
import java.io.File

interface MineHttp  {
    fun getMyFundList(param: FundListParam): Observable<BaseResponse<FundData>>

    fun getMyBalance(): Observable<BaseResponse<BalanceBean>>

    fun deleteAccount(param: com.yidianling.user.mine.bean.DefaultAccountCmd): Observable<BaseResponse<Any>>

    fun editAccount(param: com.yidianling.user.mine.bean.EditAccountCmd): Observable<BaseResponse<AccountBean>>

    fun feedBack(param: FeedBackParam, files: Array<File>?): Observable<BaseResponse<Any>>

    fun getFeedBackDetail(id:String): Observable<BaseResponse<FeedBackDetailBean>>

    fun getRechargeId(param: RechargeParam): Observable<BaseResponse<Recharge>>

    fun setDefaultAccount(param: com.yidianling.user.mine.bean.DefaultAccountCmd): Observable<BaseResponse<Any>>

    fun getAccountList(): Observable<BaseResponse<MutableList<AccountBean>>>

    fun applyAccount(param: com.yidianling.user.mine.bean.WithDrawCmd): Observable<BaseResponse<Any>>

    fun addAccount(param: com.yidianling.user.mine.bean.AddAccountCmd): Observable<BaseResponse<AccountBean>>

    fun appWillUp(param: APPWillUpParam): Observable<BaseResponse<MustUP>>

    fun getNewCoupon(param: BaseCommand): Observable<BaseResponse<CouponNumBean>>

    fun getUserInfo(): Observable<BaseAPIResponse<UserResponseBean>>

    fun getSysMsgList(param: MsgListParam): Observable<BaseResponse<String>>

    fun getHasConfideOrder(uid: String): Observable<BaseAPIResponse<EvaluateOrderBean>>

    //获取测评vip数据
    fun effectivity(): Observable<BaseAPIResponse<MutableList<EffectivityBean>>>
}