package com.yidianling.user.mine.http

import com.google.gson.Gson
import com.ydl.ydlcommon.bean.MustUP
import com.ydl.ydlcommon.data.http.*
import com.ydl.ydlcommon.utils.NetworkParamsUtils
import com.ydl.ydlnet.YDLHttpUtils
import com.yidianling.im.message.param.MsgListParam
import com.yidianling.user.api.bean.UserResponseBean
import com.yidianling.user.bean.EffectivityBean
import com.yidianling.user.bean.EvaluateOrderBean
import com.yidianling.user.bean.FundData
import com.yidianling.user.bean.Recharge
import com.yidianling.user.mine.APPWillUpParam
import com.yidianling.user.mine.FeedBackParam
import com.yidianling.user.mine.FundListParam
import com.yidianling.user.mine.RechargeParam
import com.yidianling.user.mine.bean.AccountBean
import com.yidianling.user.mine.bean.BalanceBean
import com.yidianling.user.mine.bean.FeedBackDetailBean
import com.yidianling.user.mine.bean.UserInfoCmd
import io.reactivex.Observable
import okhttp3.MediaType
import okhttp3.RequestBody
import java.io.File
import java.util.*

class MineHttpImpl private constructor() : MineHttp {

    companion object {
        fun getInstance(): MineHttpImpl {
            return Holder.INSTANCE
        }

        fun clearAppApi() {
            Holder.INSTANCE.appApi = null
        }

    }

    private var appApi: MineApi? = null

    private fun getAppApi(): MineApi {
        if (appApi == null) {
            appApi = YDLHttpUtils.obtainApi(MineApi::class.java)
        }

        return appApi!!
    }

    fun getPostList(crq: BaseCommand): List<FormatText> {
        return NetworkParamsUtils.getPostList(crq)
    }

    fun getMaps(list: List<FormatText>): Map<String, String> {
        return NetworkParamsUtils.getMaps(list)
    }

    override fun getMyFundList(param: FundListParam): Observable<BaseResponse<FundData>> {
        return RxUtils.mapObservable(param)
            .flatMap { getAppApi().getMyFundList(it) }
    }

    override fun getMyBalance(): Observable<BaseResponse<BalanceBean>> {
        return getAppApi().getMyBalance()
    }

    override fun deleteAccount(param: com.yidianling.user.mine.bean.DefaultAccountCmd): Observable<BaseResponse<Any>> {
        return RxUtils.mapObservable(param)
            .flatMap { getAppApi().deleteAccount(it) }
    }

    override fun editAccount(param: com.yidianling.user.mine.bean.EditAccountCmd): Observable<BaseResponse<AccountBean>> {
        return RxUtils.mapObservable(param)
            .flatMap { getAppApi().editAccount(it) }
    }

    override fun feedBack(param: FeedBackParam, files: Array<File>?): Observable<BaseResponse<Any>> {
        val map = NetworkParamsUtils.getFileMaps(param, "image", files!!)
        return getAppApi().feedBack(map)
    }

    override fun getFeedBackDetail(id: String): Observable<BaseResponse<FeedBackDetailBean>> {

        return getAppApi().getFeedBackDetail(id).compose(RxUtils.netCheck())
    }


    override fun getRechargeId(param: RechargeParam): Observable<BaseResponse<Recharge>> {
        return RxUtils.mapObservable(param)
            .flatMap { getAppApi().getRechargeId(it) }
    }

    override fun setDefaultAccount(param: com.yidianling.user.mine.bean.DefaultAccountCmd): Observable<BaseResponse<Any>> {
        return RxUtils.mapObservable(param)
            .flatMap { getAppApi().setDefaultAccount(it) }
    }

    override fun getAccountList(): Observable<BaseResponse<MutableList<AccountBean>>> {
        return getAppApi().getAccountList("").compose(RxUtils.netCheck())
    }

    override fun applyAccount(param: com.yidianling.user.mine.bean.WithDrawCmd): Observable<BaseResponse<Any>> {
        return RxUtils.mapObservable(param)
            .flatMap { getAppApi().applyAccount(it) }
    }

    override fun addAccount(param: com.yidianling.user.mine.bean.AddAccountCmd): Observable<BaseResponse<AccountBean>> {
        return RxUtils.mapObservable(param)
            .flatMap { getAppApi().addAccount(it) }
    }

    override fun appWillUp(param: APPWillUpParam): Observable<BaseResponse<MustUP>> {
        return RxUtils.mapObservable(param)
            .flatMap { getAppApi().appWillUp(it) }
    }

    override fun getNewCoupon(param: BaseCommand): Observable<BaseResponse<com.yidianling.user.mine.bean.CouponNumBean>> {
        val list = NetworkParamsUtils.getPostList(param)
        return getAppApi().getNewCoupon(NetworkParamsUtils.getMaps(list))
    }

    override fun getUserInfo(): Observable<BaseAPIResponse<UserResponseBean>> {

        var param: String = Gson().toJson(UserInfoCmd())
        val body = RequestBody.create(MediaType.parse("application/json; charset=utf-8"), param)

        return getAppApi().getUserInfo(body).compose(RxUtils.netCheck())
    }

    override fun getSysMsgList(param: MsgListParam): Observable<BaseResponse<String>> {
        return RxUtils.mapObservable(param)
            .flatMap { getAppApi().getSysMsgList(it) }
    }

    override fun getHasConfideOrder(uid: String): Observable<BaseAPIResponse<EvaluateOrderBean>> {
        var param = WeakHashMap<String, String>().toMutableMap()
        param["uid"] = uid
        val body =
            RequestBody.create(MediaType.parse("application/json; charset=utf-8"), param.toString())
        return getAppApi().hasConfideOrder(body)
    }

    override fun effectivity(): Observable<BaseAPIResponse<MutableList<EffectivityBean>>> {
        return getAppApi().effectivity()
    }

    object Holder {
        val INSTANCE = MineHttpImpl()
    }
}