package com.yidianling.user.modular_service

import android.app.Activity
import android.content.Context
import android.os.Bundle
import com.alibaba.android.arouter.facade.annotation.Route
import com.alibaba.android.arouter.launcher.ARouter
import com.ydl.webview.H5Params
import com.ydl.webview.NewH5Activity
import com.ydl.ydlcommon.base.config.HttpConfig
import com.yidianling.user.api.service.IAppService


@Route(path = "/user/AppService")
class AppServiceImpl: IAppService {

    override fun mainIntent(activity: Activity) {
        ARouter.getInstance()
            .build("/main/main")
            .navigation()
    }

    override fun mainIntent(context: Context, selectTab: Int, animation: Boolean) {
        val bundle = Bundle()
        bundle.putInt("selectTab", selectTab)
        bundle.putBoolean("animation", animation)

        ARouter.getInstance().build("/main/main")
            .withBundle("bundle",bundle)
            .navigation()
    }

    override fun myRedPockIntent(activity: Activity) {
        NewH5Activity.start(activity, H5Params(HttpConfig.H5_URL + "coupon/my-coupon", "红包卡券"),"使用说明") {
            val RedPacketIntroUrl = "https://h2.yidianling.com/ex-help/98"
            val h5Params = H5Params(RedPacketIntroUrl, "使用说明")
            NewH5Activity.start(activity, h5Params)
        }
    }

    override fun receiverRedPacketIntent(activity: Activity, param: String) {
        ARouter.getInstance().build("/user/receiveRedPacket").withString("paramStr",param).navigation()
    }

    override fun personalInfoIntent(activity: Activity) {
        ARouter.getInstance().build("/user/personInfo").navigation()
    }

    override fun rechargeIntent(activity: Activity) {
        ARouter.getInstance().build("/user/recharge").navigation()
    }

    override fun splashIntent(activity: Activity) {
        ARouter.getInstance().build("/main/splash").navigation()
    }

    override fun feedBackIntent(activity: Activity) {
        ARouter.getInstance().build("/mine/FeedBackActivity").navigation()
    }

    override fun sendRedPacketIntent(activity: Activity, toUid: String) {
        ARouter.getInstance().build("/user/sendRedPacket").withString("to_uid",toUid).navigation()
    }

    override fun notificationSettingIntent(activity: Activity) {
        ARouter.getInstance().build("/user/notifysetting").navigation()
    }

    override fun privacyIntent(activity: Activity) {
        ARouter.getInstance().build("/user/privacy").navigation()
    }

    override fun accountHistoryIntent(activity: Activity) {
        ARouter.getInstance().build("/mine/AccountHistoryActivity").navigation()
    }

    override fun rechargeActivityIntent(activity: Activity) {
        ARouter.getInstance().build("/user/recharge").navigation()
    }

    override fun init(context: Context?) {

    }

}