package com.yidianling.user.route

import android.app.Activity
import android.content.Context
import com.ydl.ydlcommon.modular.ModularServiceManager
import com.yidianling.fm.api.service.IFMService
import com.yidianling.im.api.bean.IMLoginInfo
import com.yidianling.im.api.bean.IMRequestCallback
import com.yidianling.im.api.service.IImService
import com.yidianling.user.api.service.IAppService
import com.yidianling.user.api.service.IUserService

/**
 * author : Zhangwenchao
 * e-mail : zhangwch@yidianling.com
 * time   : 2018/02/05
 */
object UserIn {

    fun getImService(): IImService {
        return ModularServiceManager.provide(IImService::class.java)
    }

    fun getAppService(): IAppService {
        return ModularServiceManager.provide(IAppService::class.java)
    }

    fun getUserService(): IUserService {
        return ModularServiceManager.provide(IUserService::class.java)
    }

    fun getFmService(): IFMService{
        return ModularServiceManager.provide(IFMService::class.java)
    }

    fun mainIntent(activity: Activity){
        getAppService().mainIntent(activity)
    }
    fun mainIntent(context: Context, selectTab: Int){
        getAppService().mainIntent(context, selectTab, false)
    }

    fun imSetAccount(account: String) {
        getImService().setAccount(account)
    }

    fun splashIntent(activity: Activity){
        getAppService().splashIntent(activity)
    }

    fun setChattingAccountAll() {
        getImService().setChattingAccountAll()
    }

    fun setChattingAccountNone() {
        getImService().setChattingAccountNone()
    }

    fun imLogin(info: IMLoginInfo, callback: IMRequestCallback<IMLoginInfo>) {
        getImService().login(info, callback)
    }

    fun imLogout() {
        getImService().logout()
    }

    // 关闭音频播放
    fun closePlayer() {
        getFmService().closePlayer()
    }

    // 清除 im 数据
    fun clearImData() {
        getImService().clear()
    }

}