package com.yidianling.user.safePrivate

import android.content.Intent
import android.view.View
import android.widget.LinearLayout
import android.widget.RelativeLayout
import android.widget.TextView
import com.alibaba.android.arouter.facade.annotation.Route
import com.ydl.ydlcommon.base.BaseActivity
import com.ydl.ydlcommon.bean.StatusBarOptions
import com.ydl.ydlcommon.view.MyToggleButton
import com.ydl.ydlcommon.view.dialog.CommonDialog
import com.yidianling.user.R
import com.yidianling.user.UserConstants
import com.yidianling.user.UserHelper
import com.yidianling.user.ui.InputPhoneActivity

/**
 * 安全隐私--手势解锁--指纹解锁
 * Created by harvie on 2017/6/10 0010.
 */
@Route(path = "/user/privacy")
class PrivacyActivity : BaseActivity() {
    override fun layoutResId(): Int {
        return R.layout.user_activity_me_privacy
    }

    override fun initDataAndEvent() {
        init()
    }

    override fun getStatusViewOptions(): StatusBarOptions {
        return StatusBarOptions(true,true)
    }

    var rela_finger: android.widget.RelativeLayout? = null

    var fingerToggle: MyToggleButton? = null
    var handToggle: MyToggleButton? = null

    var finger_tip: TextView? = null
    var lin_update: LinearLayout? = null

    override fun onResume() {
        super.onResume()
        //设置开关状态
        setStatus()
    }

    fun setStatus() {
        //设置开关状态
        if (FingerPrintUtil.Companion.instance().fingerPrintIsOpen()) {
            fingerToggle?.setToggleOn()
        } else {
            fingerToggle?.setToggleOff()
        }

        if (!FingerPrintUtil.Companion.instance().getHandPass().equals("")) {
            handToggle?.setToggleOn()
        } else {
            handToggle?.setToggleOff()
        }

        if (!FingerPrintUtil.instance().getHandPass().equals("")) {
            lin_update?.visibility = View.VISIBLE
        } else {
            lin_update?.visibility = View.GONE
        }
    }

    fun init() {
        finger_tip = findViewById<TextView>(R.id.finger_tip) as TextView
        rela_finger = findViewById<RelativeLayout>(R.id.rela_finger) as RelativeLayout
        fingerToggle = findViewById<MyToggleButton>(R.id.zhiwen) as MyToggleButton
        handToggle = findViewById<MyToggleButton>(R.id.shoushi) as MyToggleButton
        lin_update = findViewById<LinearLayout>(R.id.lin_update) as LinearLayout

        //修改手势密码
        lin_update?.setOnClickListener({
            startActivity(Intent(mContext, CheckPasswordActivity::class.java))
        })

        var bo: Boolean? = FingerPrintUtil.Companion.instance().isFingerPrintAvaliable()
        if (bo != null && bo) {
            //支持指纹的设备显示指纹解锁栏目
            rela_finger?.visibility = android.view.View.VISIBLE
            finger_tip?.visibility = android.view.View.VISIBLE

            fingerToggle?.setOnToggleChanged(object : MyToggleButton.OnToggleChanged {
                override fun onToggle(on: Boolean) {
                    if (on) {
                        //开启指纹识别--验证指纹
                        //如果用户没有可用指纹--提示录入指纹
                        if (FingerPrintUtil.Companion.instance().isHaveFingerPrint() ?: false == false) {

                            CommonDialog(mContext)
                                    .setMessage("\n你尚未设置指纹或指纹功能\n未启用，请在手机系统中添加指纹\n")
                                    .setRightClick("确定", {
                                        fingerToggle?.setToggleOff()
                                    })
                                    .setCancelAble(false)
                                    .show()
                            return
                        }

                        //判断是否绑定手机号
                        if (!UserHelper.isBindPhone()) {
                            CommonDialog(mContext)
                                    .setMessage("\n为了您的账号安全，请绑定手机号\n")
                                    .setLeftOnclick("取消", {
                                        fingerToggle?.setToggleOff()
                                    })
                                    .setRightClick("确定", {
                                        fingerToggle?.setToggleOff()
                                        //跳转绑定手机号页面
                                        InputPhoneActivity.start(mContext, UserConstants.BIND_PHONE_ACTION, null, false)
                                    })
                                    .setCancelAble(false)
                                    .show()
                            return
                        }
                        //跳转指纹设置页
                        startActivity(Intent(mContext, SetFingerPrintActivity::class.java))
                    } else {
                        //提示
                        CommonDialog(mContext)
                                .setMessage("\n确认关闭指纹解锁？\n")
                                .setLeftOnclick("取消", {
                                    fingerToggle?.setToggleOn()
                                })
                                .setRightClick("确定", {
                                    //关闭指纹识别
                                    FingerPrintUtil.Companion.instance().setFingerStatus(on)
                                })
                                .setCancelAble(false)
                                .show()
                    }
                }

            })
        }


        handToggle?.setOnToggleChanged(object : MyToggleButton.OnToggleChanged {
            override fun onToggle(on: Boolean) {
                if (on) {
                    //判断是否绑定手机号
                    if (!UserHelper.isBindPhone()) {
                        CommonDialog(mContext)
                                .setMessage("\n为了您的账号安全，请绑定手机号\n")
                                .setLeftOnclick("取消", {
                                    handToggle?.setToggleOff()
                                })
                                .setRightClick("确定", {
                                    handToggle?.setToggleOff()
                                    //跳转绑定手机号页面
                                    InputPhoneActivity.start(mContext, UserConstants.BIND_PHONE_ACTION, null, false);
                                })
                                .setCancelAble(false)
                                .show()
                        return
                    }

                    //验证登录密码
                    CheckPasswordActivity.startActivity(mContext)
                } else {
                    //提示
                    CommonDialog(mContext)
                            .setMessage("\n确认关闭手势密码？\n")
                            .setLeftOnclick("取消", {
                                handToggle?.setToggleOn()
                            })
                            .setRightClick("确定", {
                                lin_update?.visibility = View.GONE
                                FingerPrintUtil.Companion.instance().setHandPassword("")
                            })
                            .show()
                }
            }
        })

    }
}
