package com.yidianling.user.safePrivate

import android.view.View
import android.widget.TextView
import com.ydl.ydlcommon.base.BaseActivity
import com.ydl.ydlcommon.bean.StatusBarOptions
import com.ydl.ydlcommon.view.TitleBar
import com.ydl.ydlcommon.view.dialog.CommonDialog
import com.yidianling.common.tools.ToastUtil
import com.yidianling.user.R
import com.yidianling.user.UserHelper
import com.yidianling.user.ui.login.RegisterAndLoginActivity

/**
 * 设置指纹
 */
class SetFingerPrintActivity : BaseActivity(), View.OnClickListener {
    override fun layoutResId(): Int {
        return R.layout.user_activity_finger_print_set
    }

    override fun initDataAndEvent() {
        init()
    }
    override fun getStatusViewOptions(): StatusBarOptions {
        return StatusBarOptions(true,true)
    }

    var title_bar: TitleBar? = null
    var checkText: TextView? = null

    fun init() {
        title_bar = findViewById<TitleBar>(R.id.title_bar)
        checkText = findViewById<TextView>(R.id.text_check)

        checkText?.setOnClickListener(this)

        //开始验证
        checkFinger()
    }

    override fun onClick(v: View) {
        when (v.id) {
            R.id.text_check -> {
                //弹出验证
                checkFinger()
            }
            R.id.text_login -> {
                //跳转登录验证
                RegisterAndLoginActivity.start(this@SetFingerPrintActivity)
            }
        }
    }

    //弹窗开始验证
    fun checkFinger() {

        var dia = CommonDialog(mContext)
                .setImageCenter(R.drawable.user_lock_ico_zhiwen)
                .setMessage("验证已有手机指纹")
                .setRightClick("取消") {

                }
                .setOnDismiss {
                    //停止指纹监听
                    FingerPrintUtil.instance().cancelFingerListener()
                }
        dia.show()
        //判断系统指纹是否可用
        if (!FingerPrintUtil.getFingerPrintIsAviable()) {
            if (dia != null) {
                dia.setMessage(FingerPrintUtil.errorMoreMessage).setMessageColor(R.color.platform_price_color)
                FingerPrintUtil.instance().cancelFingerListener()

            }
            return
        }

        FingerPrintUtil.instance().startFingerPrint(object : FingerPrintUtil.FingerCallback {
            override fun onAuthenticationSucceeded() {
                //设置成功
                ToastUtil.toastShort("设置成功")
                FingerPrintUtil.instance().setFingerStatus(true)
                FingerPrintUtil.instance().cancelFingerListener()
                //隐藏红点
                UserHelper.getUsetSetting()?.meSafePrivateIsClick = true
                finish()
            }

            override fun onAuthenticationFailed() {
                if (dia != null) {
                    dia.setMessage(FingerPrintUtil.errorMessage).setMessageColor(R.color.platform_price_color)
                    //设置抖动动画
                    dia.setMessageShake(true)
                }

            }

            override fun onAuthenticationError() {
                if (dia != null) {
                    dia.setMessage(FingerPrintUtil.errorMoreMessage)
                    dia.dismiss()
                }
                ToastUtil.toastShort(FingerPrintUtil.errorTime)

                //保存当前错误时间
                UserHelper.getUsetSetting()?.fingerErrorTime = System.currentTimeMillis()
                finish()
            }

        })


    }
}
