package com.yidianling.user.ui;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;
import com.ydl.ydlcommon.base.BaseActivity;
import com.ydl.ydlcommon.bean.StatusBarOptions;
import com.ydl.ydlcommon.data.http.RxUtils;
import com.ydl.ydlcommon.data.http.ThrowableConsumer;
import com.ydl.ydlcommon.utils.StatusBarUtils;
import com.ydl.ydlcommon.utils.remind.ToastHelper;
import com.yidianling.user.R;
import com.yidianling.user.http.UserHttp;
import com.yidianling.user.http.UserHttpImpl;
import com.yidianling.user.http.response.CountryResponse.Country;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;


/**
 * 选择国家和地区
 * Created by Wi1ls on 2016/11/23;
 */
public class CountryListActivity extends BaseActivity {
    ListView mListView;
    ImageView iv_close;
    String userCountryCode;
    private CountryAdapter mAdapter;

    private List<Country> list = new ArrayList<>();

    @Override
    protected int layoutResId() {
        return R.layout.user_activity_country_list;
    }
    @NotNull

    @Override
    public StatusBarOptions getStatusViewOptions() {
        return new StatusBarOptions(true,true);
    }

    @Override
    protected void initDataAndEvent() {
        StatusBarUtils.Companion.setTransparent(this);
        Intent intent = getIntent();
        userCountryCode = intent.getStringExtra("userCountryCode");
        mListView = findViewById(R.id.country_lv);
        iv_close = findViewById(R.id.iv_close);
        iv_close.setOnClickListener(view -> {
            overridePendingTransition(0, R.anim.platform_slide_out_to_bottom);
            finish();
        });
        init();
    }


    void init() {
        mAdapter = new CountryAdapter(list, this, userCountryCode);
        mListView.setAdapter(mAdapter);
        getData();
    }


    @SuppressLint("CheckResult")
    public void getData() {
        UserHttp userHttp = UserHttpImpl.Companion.getInstance();
        userHttp.countryList()
                .subscribeOn(Schedulers.io())
                .compose(RxUtils.resultData())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe(countryResponse -> {
                    list.addAll(countryResponse.getCountryList());
                    mAdapter.notifyDataSetChanged();
                }, new ThrowableConsumer() {
                    @Override
                    public void accept(@NotNull String msg) {
                        ToastHelper.Companion.show(msg);
                    }
                });

    }


    public class CountryAdapter extends BaseAdapter {
        private List<Country> list;
        private Context context;
        private String userCountryCode;

        public CountryAdapter(List<Country> list, Context context, String userCountryCode) {
            this.list = list;
            this.context = context;
            this.userCountryCode = userCountryCode;
        }

        @Override
        public int getCount() {
            return list.size();
        }

        @Override
        public Object getItem(int position) {
            return list.get(position);
        }

        @Override
        public long getItemId(int position) {
            return position;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            View view = LayoutInflater.from(context).inflate(R.layout.user_item_country_phone_code, parent, false);
            TextView nameTv = view.findViewById(R.id.tv_name);
            TextView codeTv = view.findViewById(R.id.tv_code);
            final Country c = list.get(position);
            nameTv.setText(c.getName());
            codeTv.setText("+" + c.getCode().replace("00", ""));

            if (c.getCode().equals(userCountryCode)) {
                nameTv.setTextColor(Color.parseColor("#1DA1F2"));
                codeTv.setTextColor(Color.parseColor("#1DA1F2"));
            }

            view.setOnClickListener(v -> {
                Intent i = new Intent();
                i.putExtra("code", c.getCode());
                i.putExtra("name", c.getName());
                i.putExtra("en_name", c.getEn_name());
                setResult(45, i);
                overridePendingTransition(0, R.anim.platform_slide_out_to_bottom);
                finish();
            });
            return view;
        }
    }
}
