package com.yidianling.user.ui;

import android.content.Context;
import android.content.Intent;
import androidx.appcompat.app.AlertDialog;
import android.text.TextUtils;
import android.view.View;
import com.ydl.ydlcommon.base.BaseMvpActivity;
import com.ydl.ydlcommon.data.http.EncryptUtils;
import com.ydl.ydlcommon.utils.ActivityManager;
;
import com.ydl.ydlcommon.utils.log.LogHelper;
import com.ydl.ydlcommon.utils.remind.ToastHelper;
import com.ydl.ydlcommon.view.DeleteEditTextView;
import com.ydl.ydlcommon.view.JumpTextView;
import com.ydl.ydlcommon.view.RoundCornerButton;
import com.ydl.ydlcommon.view.TitleBar;
import com.yidianling.user.api.bean.UserResponseBean;
import com.yidianling.user.LoginContract;
import com.yidianling.user.LoginPresenter;
import com.yidianling.user.R;
import com.yidianling.user.UserConstants;
import com.yidianling.user.http.request.LoginParam;
import com.yidianling.user.route.UserIn;
import com.yidianling.user.safePrivate.FingerPrintCheckActivity;
import com.yidianling.user.safePrivate.FingerPrintUtil;
import com.yidianling.user.safePrivate.HandUnlockCheckActivity;
import org.jetbrains.annotations.NotNull;


/**
 * 手机登陆界面
 */
public class LoginActivity extends BaseMvpActivity<LoginContract.View,LoginContract.Presenter> implements LoginContract.View, View.OnClickListener {

    private String defaultCode = "0086";
    int isSplash;

    TitleBar tbTitle;
    DeleteEditTextView tvPhone;
    DeleteEditTextView tvPassword;
    RoundCornerButton btnLogin;
    JumpTextView tvCountry;
    private boolean isFromSplash;

    private static String IS_SPLASH = "isSplash";
    private static String IS_FROM_SPLASH = "isFromSplash";

    public static Intent newIntent(Context context, int isSplash, boolean isFromSplash) {
        Intent intent = new Intent(context, LoginActivity.class);
        intent.putExtra(IS_SPLASH, isSplash);
        intent.putExtra(IS_FROM_SPLASH, isFromSplash);
        return intent;
    }


    @Override
    protected int layoutResId() {
        return R.layout.user_activity_login;
    }

    @Override
    protected void initDataAndEvent() {
        LogHelper.Companion.getInstance().writeLogSync("登录界面创建");
        tbTitle = findViewById(R.id.tb_title);
        tvPhone = findViewById(R.id.detv_phone);
        tvPassword = findViewById(R.id.detv_password);
        btnLogin = findViewById(R.id.rcb_login);
        tvCountry = findViewById(R.id.jtv_country);

        tvCountry.setOnClickListener(this);
        findViewById(R.id.sms_fast_login).setOnClickListener(this);
        btnLogin.setOnClickListener(this);
        findViewById(R.id.register).setOnClickListener(this);
        isSplash = getIntent().getIntExtra(IS_SPLASH, 0);
        isFromSplash = getIntent().getBooleanExtra(IS_FROM_SPLASH, false);
        init();
    }


    @NotNull
    @Override
    public LoginContract.Presenter createPresenter() {
        return new LoginPresenter(this);
    }

    void init() {
        if (isSplash == -1) {//启动app进入,无取消
            tbTitle.setmLeftText("");
            tbTitle.setOnLeftTextClick((view, isActive) -> {
            });
        } else {//推出帐号进入的login,有取消
            tbTitle.setOnLeftTextClick((view, isActive) -> LoginActivity.this.finish());
        }
    }


    @Override
    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.sms_fast_login) {
            InputPhoneActivity.start(this, UserConstants.SIGNIN_ACTION, tvPhone.getText().toString(), isFromSplash);
        } else if (i == R.id.rcb_login) {
            login();

        } else if (i == R.id.register) {
            InputPhoneActivity.start(this, UserConstants.REGISTER_ACTION, null, isFromSplash);

        } else if (i == R.id.jtv_country) {
            startActivityForResult(new Intent(this, CountryListActivity.class), 44);

        }
    }


    private void login() {
        final String phone = tvPhone.getText().toString();
        if (TextUtils.isEmpty(phone)) {
            ToastHelper.Companion.show("请输入正确的手机号");
            return;
        }
        final String password = EncryptUtils.encryptMD5ToString(tvPassword.getText().toString());
        getPresenter().login(new LoginParam(defaultCode, phone, password, 1, null));
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 44 && resultCode == 45) {
            defaultCode = data.getStringExtra("code");
            String defaultCountry = data.getStringExtra("name");
            tvCountry.setLeftText(String.format("%s   +%s", defaultCountry, defaultCode));
        }
    }

    @Override
    public void startLogin() {
        btnLogin.disableButton();
        showProgressDialog("");
    }

    @Override
    public void loginSuccess(UserResponseBean userInfo) {
        finishFinger();
        int size = ActivityManager.Companion.getActivitySize();
        if (size == 2 || size == 1) {
            ActivityManager.Companion.finishAll();
            UserIn.INSTANCE.mainIntent(this);
        } else {
            finish();
        }
    }

    //关闭手势解锁页面与指纹解锁页面
    private void finishFinger() {
        ActivityManager.Companion.getInstance().finishActivity(FingerPrintCheckActivity.class);
        ActivityManager.Companion.getInstance().finishActivity(HandUnlockCheckActivity.class);
        FingerPrintUtil.Companion.instance().setCurrentUnLockTime(System.currentTimeMillis());
    }

    @Override
    public void loginFail(@NotNull String msg) {
        ToastHelper.Companion.show(msg);
    }

    @Override
    public void onLoginStop() {
        dismissProgressDialog();
        btnLogin.enableButton();
    }

    @Override
    public void showErrorUserType() {
        dismissProgressDialog();
        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setTitle("请注意");
        builder.setMessage("专家账号，请下载壹点灵专家版app喔");
        builder.setPositiveButton("确定", (dialog, which) -> dialog.dismiss());
        AlertDialog alertDialog = builder.create();
        alertDialog.show();
    }
}
