package com.yidianling.user.ui.collect.widget

import android.content.Context
import android.content.res.Resources
import android.graphics.Color
import android.graphics.drawable.ColorDrawable
import android.util.AttributeSet
import android.view.View
import android.view.ViewGroup
import android.widget.EditText
import android.widget.NumberPicker

/**
 * 自定义数字选择器
 */

class CustomNumberPicker: NumberPicker {

    constructor(context: Context): super(context)

    constructor(context: Context, attrs: AttributeSet): super(context, attrs)

    constructor(context: Context, attrs: AttributeSet, defStyleAttr: Int): super(context, attrs, defStyleAttr)

    override fun addView(child: View) {
        updateView(child)
    }

    override fun addView(child: View, width: Int, height: Int) {
        super.addView(child, width, height)
        updateView(child)
    }

    override fun addView(child: View, index: Int, params: ViewGroup.LayoutParams) {
        super.addView(child, index, params)
        updateView(child)
    }

    override fun addView(child: View, params: ViewGroup.LayoutParams) {
        super.addView(child, params)
        updateView(child)
    }

    fun updateView(view: View) {
        if (view is EditText) {
            //这里修改显示字体的属性，主要修改颜色和大小
//            view.setTextColor(Color.parseColor("#242424"))
            view.textSize = 22f
        }
    }

    /**
     * 设置picker分割线的颜色
     */
    public fun setDividerColor(colorString: String) {
        val field = NumberPicker::class.java.getDeclaredField("mSelectionDivider")
        if (field != null) {
            field.isAccessible = true
            field.set(this, ColorDrawable(Color.parseColor(colorString)))
        }
    }

    /**
     * 设置picker分割线的宽度
     */
    public fun setNumberPickerDividerHeight(height: Int) {
        val fields = NumberPicker::class.java.declaredFields
        for (f in fields) {
            if (f.name == "mSelectionDividerHeight") {
                f.isAccessible = true
                f.set(this, height)
                break
            }
        }
    }

    /**
     * 设置picker分割线透明
     */
    public fun setNumberPickerDividerColorTransparent() {
        val pickerFields = NumberPicker::class.java.declaredFields
        for (pf in pickerFields) {
            if (pf.name.equals("mSelectionDivider")) {
                pf.isAccessible = true
                try {
                    //设置分割线的颜色值 透明
                    pf.set(
                        this,
                        ColorDrawable(this.resources.getColor(android.R.color.transparent))
                    )
                } catch (e: IllegalArgumentException) {
                    e.printStackTrace()
                } catch (e: Resources.NotFoundException) {
                    e.printStackTrace()
                } catch (e: IllegalAccessException) {
                    e.printStackTrace()
                }

                break
            }
        }
    }
}