package com.yidianling.user.ui.login.contract

import com.ydl.ydlcommon.data.http.BaseResponse
import com.ydl.ydlcommon.mvp.base.IModel
import com.ydl.ydlcommon.mvp.base.IPresenter
import com.ydl.ydlcommon.mvp.base.IView
import com.yidianling.user.api.bean.UserResponseBean
import com.yidianling.user.http.request.PhoneLoginPwdParam
import com.yidianling.user.http.request.PhoneResetPwdParam
import io.reactivex.Observable

/**
 * @author jiucheng
 * @描述:密码输入页面约束类
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/11/29
 */
interface IInputPassWordContract {
    interface View : IView {
        /**
         *菊花框
         */
        fun showLoading(state: Boolean)

        /**
         * 输入错误的动画
         */
        fun startAnim()

        /**
         * 弹窗
         */
        fun showNormalDialog()

        /**
         * 关闭页面
         */
        fun closeActivity()

        /**
         * 三方登录成功后如果判断是第一次登录，则未注册，进行百度埋点
         */
        fun baiduActionBury()
    }

    interface Presenter : IPresenter<View> {
        /**
         * 手机号密码登录
         */
        fun userLoginByPassword(inputPassword: String, phone: String, phoneCountryCode: String)

        /**
         * 重新设置密码
         */
        fun resetPwd(inputPassword: String, phone: String, msgCode: String, phoneCountryCode: String)
    }

    interface Model : IModel {
        /**
         * 手机号密码登录
         */
        fun userLoginByPassword(param: PhoneLoginPwdParam): Observable<BaseResponse<UserResponseBean>>

        /**
         * 重新设置密码
         */
        fun resetPwd(param: PhoneResetPwdParam): Observable<BaseResponse<UserResponseBean>>
    }
}