package com.yidianling.user.ui.login.contract

import com.ydl.ydlcommon.data.http.BaseResponse
import com.ydl.ydlcommon.mvp.base.IModel
import com.ydl.ydlcommon.mvp.base.IPresenter
import com.ydl.ydlcommon.mvp.base.IView
import com.yidianling.user.api.bean.UserResponseBean
import com.yidianling.user.http.request.BindPhoneJavaParam
import com.yidianling.user.http.request.PhoneLoginCodeParam
import io.reactivex.Observable

/**
 * @author jiucheng
 * @描述:验证码页面约束类
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/11/29
 */
interface IVerificationCodeContract {
    interface View : IView {
        /**
         *菊花框
         */
        fun showLoading(state: Boolean)

        /**
         * 开始倒计时
         */
        fun startCountdown(remainTime: Int)

        /**
         * 重置密码的验证码校验成功
         */
        fun checkResetCodeSuccess(code: String)

        /**
         * 手机号绑定成功
         */
        fun bindSuccess()

        /**
         * 关闭页面
         */
        fun closeActivity()

        /**
         * 动画
         */
        fun startAnim()

        /**
         * 百度监测埋点
         */
        fun baiduActionBury()

        /*
        * 验证码错误&异常超时等回调
        * */
        fun verificationErrorCode()
    }

    interface Presenter : IPresenter< View> {
        /**
         * 发送登录验证码
         */
        fun sendLoginCode(phone: String, phoneCountryCode: String)

        /**
         * 重置密码的验证码(重置密码就是忘记密码)
         */
        fun sendResetCode(phone: String, countryCode: String)

        /**
         * 检查重置密码的验证码(重置密码就是忘记密码)
         */
        fun checkResetCode(phone: String, countryCode: String, msgCode: String)

        /**
         * 验证码验证码登录
         */
        fun loginByMsgCode(phone: String, countryCode: String, msgCode: String)

        /**
         *
        绑定手机号
         */
        fun bindPhone(param: BindPhoneJavaParam)

    }

    interface Model : IModel {

        /**
         * 发送登录验证码
         */
        fun sendLoginMsgCode(phone: String, countryCode: String): Observable<BaseResponse<Any>>

        /**
         * 验证码验证码登录
         */
        fun loginByMsgCode(param: PhoneLoginCodeParam): Observable<BaseResponse<UserResponseBean>>

        /**
         * 重置密码的验证码
         */
        fun sendResetCode(phone: String, countryCode: String): Observable<BaseResponse<Any>>

        /**
         * 检查重置密码的验证码(重置密码就是忘记密码)
         */
        fun checkResetCode(phone: String, countryCode: String, msgCode: String): Observable<BaseResponse<Any>>

        /**
         *
        绑定手机号
         */
        fun bindPhone(param: BindPhoneJavaParam): Observable<BaseResponse<Any>>
    }
}