package com.yidianling.user.ui.login.model

import android.app.Activity
import com.umeng.socialize.bean.SHARE_MEDIA
import com.ydl.ydlcommon.data.http.BaseResponse
import com.yidianling.user.api.bean.UserResponseBean
import com.yidianling.user.http.LoginApiRequestUtil
import com.yidianling.user.http.request.BindPhoneJavaParam
import com.yidianling.user.http.request.CheckAliAuthParam
import com.yidianling.user.http.request.PhoneLoginAutoParam
import com.yidianling.user.http.request.ThirdLoginParam
import com.yidianling.user.http.response.ChcekPhoneResponeBean
import com.yidianling.user.http.response.PhoneAuthResponseBean
import com.yidianling.user.rxlogin.LoginObservable
import com.yidianling.user.ui.login.contract.ILoginContract
import io.reactivex.Observable

/**
 * @author jiucheng
 * @描述:登录model
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/11/29
 */
class LoginModelImpl : ILoginContract.Model {
    /**
     *
    绑定手机号
     */
    override fun bindPhone(param: BindPhoneJavaParam): Observable<BaseResponse<Any>> {
        return LoginApiRequestUtil.bindPhone(param)
    }

    /**
     * 通过一键认证服务登陆
     */
    override fun autoLogin(bean: PhoneLoginAutoParam): Observable<BaseResponse<UserResponseBean>> {
        return LoginApiRequestUtil.autoLogin(bean)
    }

    /**
     * 服务端校验阿里一键认证
     */
    override fun checkAliAuth(param: CheckAliAuthParam): Observable<BaseResponse<PhoneAuthResponseBean>> {
        return LoginApiRequestUtil.checkAliAuth(param)
    }

    /**
     * 校验手机号：是否是用户版号码、是否有设置密码、是否被绑定
     */
    override fun checkPhoneStatus(phone: String, countryCode: String): Observable<BaseResponse<ChcekPhoneResponeBean>> {
        return LoginApiRequestUtil.checkPhoneStatus(phone, countryCode)
    }

    /**
     * 三方登录
     */
    override fun loginByThird(activity: Activity, media: SHARE_MEDIA): Observable<ThirdLoginParam> {
        return LoginObservable(activity, media)
    }

}