package com.channel.ydl_flutter_base.base

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.channel.ydl_flutter_base.plugin.YDLCommonPlugin
import com.ydl.ydlcommon.bean.StatusBarOptions
import com.ydl.ydlcommon.utils.StatusBarUtils
import io.flutter.view.FlutterView

/**
 * flutter fragment 基类
 * Created by xj on 2019/9/30.
 */

abstract class BaseFlutterFragment : FlutterFragment() {
    private var mFlutterView: FlutterView? = null

    open fun getStatusViewOptions(): StatusBarOptions {
        return StatusBarOptions(true, statusBarDarkMode = true)
    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View {
        mFlutterView= Flutter.createView(
            activity!!,
            lifecycle,
            initialRoute())
        YDLCommonPlugin.fragmentRegister(this, mFlutterView!!)
        initChannelPlugin(mFlutterView!!)

        if (getStatusViewOptions().isAddStatusView){
            val returnViews = StatusBarUtils.initStatusBarView(activity!!, mFlutterView!!, getStatusViewOptions())
            return returnViews[0]
        }else{
            return mFlutterView!!
        }

    }

    /**
     * 路由，例 "quick_reply"
     */
    abstract fun initialRoute(): String

    /**
     * 初始化flutter channel插件
     */
    abstract fun initChannelPlugin(flutterView: FlutterView)
}
