package com.ydl.media.audio.model

import android.text.TextUtils

import java.io.Serializable

/**
 * Created by haorui on 2019-10-27 .
 * Des:单曲信息
 */
class Music : Serializable {

    var title: String? = null // 标题
    var artist: String? = null // 艺术家
    var album: String? = null // 专辑
    var coverPath: String? = null // 封面地址
    var duration: Long = 0 // 持续时间
    var path: String? = null // 播放地址

    var canPlay: Boolean = true // 是否能播放

    override fun equals(o: Any?): Boolean {
        if (o !is Music) {
            return false
        }

        val music = o as Music

        return (TextUtils.equals(music.title, this.title)
                && TextUtils.equals(music.artist, this.artist)
                && TextUtils.equals(music.album, this.album)
                && music.duration == this.duration)
    }

    companion object {
        private const val serialVersionUID: Long = 536871008
    }
}
