package com.ydl.media.view

/**
 * Created by haorui on 2019-10-27 .
 * Des: 播放类型
 */
enum class PlayTypeEnum private constructor(private val value: Int) {

    //未指定具体类型
    PLAY_TYPE_NONE(0),
    //电台播放类型
    PLAY_TYPE_FM(1),
    //课程播放类型
    PLAY_TYPE_COURSE(2),
    //倾诉播放类型
    PLAY_TYPE_CONFIDE(3),
    //冥想播放类型
    PLAY_TYPE_MUSE(4);


    fun value(): Int {
        return value
    }

    companion object {

        fun valueOf(value: Int): PlayTypeEnum {
            when (value) {
                0 -> return PLAY_TYPE_NONE
                1 -> return PLAY_TYPE_FM
                2 -> return PLAY_TYPE_COURSE
                3 -> return PLAY_TYPE_CONFIDE
                4 -> return PLAY_TYPE_MUSE
                else -> return PLAY_TYPE_NONE
            }
        }
    }
}
