package com.yidianling.ydl_pay.common.actionpoint

import android.content.Context
import android.net.ConnectivityManager
import android.net.NetworkInfo
import com.yidianling.ydl_pay.common.http.HttpUtils
import com.yidianling.ydl_pay.common.http.utils.RxDeviceTool
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.schedulers.Schedulers


/**
 * 行为数据埋点工具类
 * Created by xj on 2019/6/22.
 */
internal class ActionCountUtils {

    companion object {

        const val TAG: String = "ActionCountUtils"

        /**
         * 基础行为数据埋点调用的方法
         */
        fun count(uid: String?, partId: String, position: String, url: String, api: String, sign1: String) {
            try {
                val actionDataParams = ActionDataBean.Builder()
                actionDataParams.partId(partId)
                actionDataParams.position(position)
                actionDataParams.url(url)

                uid?.let {
                    actionDataParams.uid(uid)
                }
                actionDataParams.time(System.currentTimeMillis())
                actionDataParams.appVersion(RxDeviceTool.getAppVersionName(RxDeviceTool.getContext()))
                actionDataParams.appId(BIConstants.APP_ID)
                actionDataParams.api(api)
                actionDataParams.manufacturer(android.os.Build.BRAND.trim().toUpperCase())
                actionDataParams.model(android.os.Build.MODEL)
                actionDataParams.os(BIConstants.OS)
                actionDataParams.osVersion(android.os.Build.VERSION.RELEASE)
                actionDataParams.wifi(if (isWifi()) 0 else 1)
                actionDataParams.sign1(sign1)
                actionDataParams.screenWidth(RxDeviceTool.getScreenWidth(RxDeviceTool.getContext()))
                actionDataParams.screenHeight(RxDeviceTool.getScreenHeight(RxDeviceTool.getContext()))

                //剩余额外参数根据需求定义

                //请求
                request(actionDataParams.build())

            } catch (e: Exception) {
            }
        }

        /**
         * 传入ActionDataParams参数，访问接口
         */
        fun request(actionDataBean: ActionDataBean) {
            try {
                HttpUtils.actionDataCount(actionDataBean)
                        .subscribeOn(Schedulers.io())
                        .observeOn(AndroidSchedulers.mainThread())
                        .subscribe({
                        }) {
                        }
            } catch (e: Exception) {
                e.printStackTrace()
            }
        }

        /**
         * 判断是否是wifi
         */
        private fun isWifi(): Boolean {
            try {
                var connectivityManager: ConnectivityManager = RxDeviceTool.getContext().getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager
                var info: NetworkInfo = connectivityManager.activeNetworkInfo
                if (info != null && info.type == ConnectivityManager.TYPE_WIFI) {
                    return true
                }
                return false
            } catch (e: Exception) {
                return false
            }

        }
    }
}